package io.github.ngspace.hudder.main;

import java.util.function.Consumer;
import java.util.function.Function;

import org.joml.Matrix4f;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.uielements.AUIElement;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1011;
import net.minecraft.class_10142;
import net.minecraft.class_1043;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4668.class_5942;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9779;
import net.minecraft.class_9851;

/**
 * Hudder.java was too messy so I moved all rendering functions into this one class
 */
public class HudderRenderer implements HudRenderCallback {
	
	private HudCompilationManager compman;
	protected static class_310 mc = class_310.method_1551();
    public static final String NL_REGEX = "\r?\n";
    
    private static final Function<class_2960, class_1921> hudder_gui_tr = class_156.method_34866(texture ->
		class_1921.method_24048("hudder_gui_tr", class_290.field_1575, class_293.class_5596.field_27380,
		786432, class_1921.class_4688.method_23598().method_34577(new class_4668.class_4683(texture,
		class_9851.field_52395, false)).method_34578(new class_5942(class_10142.field_53880)).method_23615
		(class_4668.field_21370).method_23604(class_4668.field_21348)
		.method_23617(false)));
	
	public HudderRenderer(HudCompilationManager compilationManager) {
		this.compman = compilationManager;
	}
	
	
	
	public void renderFail(class_332 context, String FailMessage) {
		var lines = mc.field_1772.method_1728(class_5348.method_29430(FailMessage), mc.method_22683().method_4486());
		int y = 1;
		for (class_5481 line : lines) {
        	context.method_51430(mc.field_1772, line, 1, y, 0xFF5555, true);
			y+=9;
		}
	}
	
	
	
	public void drawCompileResult(class_332 context, class_327 renderer, HudInformation text, HudderConfig info,
			class_9779 delta) {
        int color = info.color;
        int bgcolor = info.backgroundcolor;
        boolean shadow = info.shadow;
        boolean background = info.background;
        
        /* Top Left */
        String[] lines = text.TopLeftText.split(NL_REGEX);
        int yoff = info.yoffset;
        int xoff = info.xoffset;
        for (String txt : lines) {
        	renderTextLine(context, txt, xoff, yoff, color, text.TLScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.TLScale;
        }
        
        /* Bottom Left */
        String[] BL = text.BottomLeftText.split(NL_REGEX);
        yoff = (int) (context.method_51443() - countLines(text.BottomLeftText) *
        		info.lineHeight * text.BLScale - info.yoffset + 1);
        xoff = info.xoffset;
        for (String txt : BL) {
        	renderTextLine(context, txt, xoff, yoff, color, text.BLScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.BLScale;
        }
        
        /* Top Right */
        String[] TR = text.TopRightText.split(NL_REGEX);
        yoff = info.yoffset;
        for (String txt : TR) {
        	xoff = (int) (context.method_51421() - renderer.method_1727(txt) * text.TRScale - info.xoffset);
        	renderTextLine(context, txt, xoff, yoff, color, text.TRScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.TRScale;
        }
        
        /* Bottom Right */
        String[] BR = text.BottomRightText.split(NL_REGEX);
        yoff = (int) (context.method_51443() - countLines(text.BottomRightText) *
        		info.lineHeight * text.BRScale - info.yoffset + 1);
        for (String txt : BR) {
        	xoff = (int) (context.method_51421() - renderer.method_1727(txt) * text.BRScale - info.xoffset);
        	renderTextLine(context, txt, xoff, yoff, color, text.BRScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.BRScale;
        }
        
        for (AUIElement e : text.elements) e.renderElement(context, this, delta);
    }
	
	
	
    public int countLines(String str) {
        int count = 1;
        for (int i = 0; i<str.length();i++) if (str.charAt(i) == '\n') count++;
        return count;
    }
    
    

	public void renderTextLine(class_332 context, String text, int x, int y, int color, float scale, boolean shadow,
			boolean background, long backgroundColor) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (scale != 1.0f) {
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416(x, y, 0);
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_46416(-x, -y, 0);
    		if (background&&!"".equals(text))
    			renderBlock(context,x-1f,y-1f,mc.field_1772.method_1727(text)+2f,9f+1f,backgroundColor);
            context.method_51433(mc.field_1772, text, x, y, color, shadow);
            matrixStack.method_22909();
        } else {
    		if (background&&!"".equals(text))
    			renderBlock(context,x-1f,y-1f,mc.field_1772.method_1727(text)+2f,9f+1f,backgroundColor);
        	context.method_51433(mc.field_1772, text, x, y, color, shadow);
        }
        RenderSystem.disableBlend();
    }
	
	
	
	public void renderBlock(class_332 context, float x, float y, float width, float height, long argb) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
		RenderSystem.setShader(class_10142.field_53876);
        int alpha = (int) ((argb >> 24) & 0xFF);
        int red =   (int) ((argb >> 16) & 0xFF);
        int green = (int) ((argb >>  8) & 0xFF);
        int blue =  (int) ((argb      ) & 0xFF);

        class_287 bgBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382,
        		class_290.field_1576);
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        bgBuilder.method_22918(matrix, x, y+height, 0f).method_1336(red,green,blue,alpha);
        bgBuilder.method_22918(matrix, x+width, y+height, 0f).method_1336(red,green,blue,alpha);
        bgBuilder.method_22918(matrix, x+width, y, 0f).method_1336(red,green,blue,alpha);
        bgBuilder.method_22918(matrix, x, y, 0f).method_1336(red,green,blue,alpha);
        class_286.method_43433(bgBuilder.method_60794());
        RenderSystem.disableBlend();
	}

	public void renderTexturedVertexArray(class_332 context, float[] vertices, float[] textures,
			class_2960 id, boolean triangles) {
		context.method_64039((Consumer<class_4597>)(vcp -> {
	        RenderSystem.enableBlend();
	        RenderSystem.defaultBlendFunc();
			RenderSystem.setShader(class_10142.field_53880);
	        
	        class_4588 vertexConsumer = vcp.getBuffer(triangles ? hudder_gui_tr.apply(id) : class_1921.method_62277(id));
	        
	        Matrix4f matrix = context.method_51448().method_23760().method_23761();
	        for (int i = 0;i<vertices.length;i+=2) {
	        	vertexConsumer.method_22918(matrix,vertices[i],vertices[i+1],0f).method_22913(textures[i],textures[i+1]).method_39415(-1);
	        }
	        RenderSystem.disableBlend();
		}));
	}
	
	public void renderTexture9Slice(class_332 context, class_2960 id, float x, float y, float width,
			float height, float[] slices) {
		context.method_64039((Consumer<class_4597>)(vcp -> {
	        RenderSystem.enableBlend();
	        RenderSystem.defaultBlendFunc();
			RenderSystem.setShader(class_10142.field_53880);
	        class_4588 vconsumer = vcp.getBuffer(class_1921.method_62277(id));
	        
	        Matrix4f matrix = context.method_51448().method_23760().method_23761();
	        class_1011 img = ((class_1043)mc.method_1531().method_4619(id)).method_4525();
	        int texwidth = img.method_4307();
	        int texheight = img.method_4323();

	        float left = Math.min(slices[0],texwidth/2f);
	        float right = Math.min(slices[1],texwidth/2f);
	        float top = Math.min(slices[2],texheight/2f);
	        float bottom = Math.min(slices[3],texheight/2f);
	        
	        float middlestart_hor = x+left;
	        float middleend_hor = x+width-right;
	        float middleend_tex_hor = (texwidth-right)/texwidth;
	        float tls = left/texwidth;
	        
	        
	        float middlestart_ver = y+top;
	        float middleend_ver = y + height - bottom;
	        float middleend_tex_ver = (texheight-bottom)/texheight;
	        float lts = top/texheight;
	        
	        // Top-left
	        vconsumer.method_22918(matrix,x,y,0f).method_22913(0,0).method_39415(-1);
	        vconsumer.method_22918(matrix,x,y+top,0f).method_22913(0,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,y+top,0f).method_22913(tls,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,y,0f).method_22913(tls,0).method_39415(-1);
	        
	        // Top-middle
	        vconsumer.method_22918(matrix,middlestart_hor,y, 0f).method_22913(tls, 0).method_39415(-1);
	        vconsumer.method_22918(matrix,middlestart_hor,y+top,0f).method_22913(tls,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,y+top,0f).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,y,0f).method_22913(middleend_tex_hor,0).method_39415(-1);
	        
	        // Top-right
	        vconsumer.method_22918(matrix,middleend_hor,y,0f).method_22913(middleend_tex_hor,0).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,y+top,0f).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,y+top,0f).method_22913(1,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,y,0f).method_22913(1,0).method_39415(-1);
	        
	        
	        
	        // Middle-left
	        vconsumer.method_22918(matrix,x,middlestart_ver,0f).method_22913(0,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,x,middleend_ver,0f).method_22913(0,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,middleend_ver,0f).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,middlestart_ver,0f).method_22913(tls,lts).method_39415(-1);
	        
	        // Middle-middle
	        vconsumer.method_22918(matrix,middlestart_hor,middlestart_ver, 0f).method_22913(tls, lts).method_39415(-1);
	        vconsumer.method_22918(matrix,middlestart_hor,middleend_ver,0f).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,middleend_ver,0f).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,middlestart_ver,0f).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        
	        // Middle-right
	        vconsumer.method_22918(matrix,middleend_hor,middlestart_ver,0f).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,middleend_ver,0f).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,middleend_ver,0f).method_22913(1,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,middlestart_ver,0f).method_22913(1,lts).method_39415(-1);
	        
	        
	        
	        // Bottom-left
	        vconsumer.method_22918(matrix,x,middleend_ver,0f).method_22913(0,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,x,y+height,0f).method_22913(0,1).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,y+height,0f).method_22913(tls,1).method_39415(-1);
	        vconsumer.method_22918(matrix,x+left,middleend_ver,0f).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        
	        // Bottom-middle
	        vconsumer.method_22918(matrix,middlestart_hor,middleend_ver, 0f).method_22913(tls, middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,middlestart_hor,y+height,0f).method_22913(tls,1).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,y+height,0f).method_22913(middleend_tex_hor,1).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,middleend_ver,0f).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        
	        // Bottom-right
	        vconsumer.method_22918(matrix,middleend_hor,middleend_ver,0f).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_22918(matrix,middleend_hor,y+height,0f).method_22913(middleend_tex_hor,1).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,y+height,0f).method_22913(1,1).method_39415(-1);
	        vconsumer.method_22918(matrix,x+width,middleend_ver,0f).method_22913(1,middleend_tex_ver).method_39415(-1);
		}));
	}
	/**
	 * Draws the provided vertices on screen with the provided color and render mode
	 * @param context The render context
	 * @param vertices The array holding all the vertices
	 * @param r red
	 * @param g green
	 * @param b blue
	 * @param a alpha
	 * @param mode The rendering mode
	 */
	public void renderColoredVertexArray(class_332 context, float[] vertices, int r, int g, int b, int a,
			class_293.class_5596 mode) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
		RenderSystem.setShader(class_10142.field_53876);
		
        class_287 vertexBuilder = class_289.method_1348().method_60827(mode,
        		class_290.field_1576);
        Matrix4f matrix = context.method_51448().method_23760().method_23761();

        for (int i = 0;i<vertices.length;i+=2)
        	vertexBuilder.method_22918(matrix,vertices[i],vertices[i+1],0f).method_1336(r, g, b, a);
        
        class_286.method_43433(vertexBuilder.method_60794());
        RenderSystem.disableBlend();
	}
	
	
	
	/**
	 * If limitrate is disabled, execute the hud (done every frame).
	 * <br><br>
	 * Then, if not disabled, draw the result on screen.
	 * <br>If compilation failed then render the error with word wrapping to allow for easier readablity.
	 */
	@Override public void onHudRender(class_332 context, class_9779 delta) {
		try {
			if (!Hudder.config.limitrate) compman.compile(delta);
			if (Hudder.config.shouldDrawResult()) {
            	RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
	            try {
	            	if (compman.getResult()!=null)
	            		drawCompileResult(context, mc.field_1772, compman.getResult(), Hudder.config, delta);
	            	else
	            		renderFail(context, HudCompilationManager.LastFailMessage);
				} catch (Exception e) {
					e.printStackTrace();
				}
            	RenderSystem.disableBlend();
			}
    	} catch (RuntimeException e) {
			e.printStackTrace();
		}
		
	}
}
