package io.github.ngspace.hudder.main.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.Compilers;
import io.github.ngspace.hudder.utils.HudFileUtils;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.gui.entries.NestedListListEntry;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ConfigMenu implements ConfigScreenFactory<class_437> {
	
	protected static class_310 mc = class_310.method_1551();
	
	public static final String URL = "https://ngspace.github.io/hudder";
	
	@Override public class_437 create(class_437 parent) {
		HudderConfig config = Hudder.config;
		
//		ConfigBuilder builder = new ConfigBuilderImpl() {
//		    @Override
//		    @SuppressWarnings("unchecked")
//			public Screen build() {
//				try {
//					var f = ConfigBuilderImpl.class.getDeclaredField("fallbackCategory");
//					
//					f.setAccessible(true);
//			    	String fallbackCategory = (String) f.get(this);
//			    	
//			    	f = ConfigBuilderImpl.class.getDeclaredField("categoryMap");
//					f.setAccessible(true);
//			    	Map<String, ConfigCategory> categoryMap = (Map<String, ConfigCategory>) f.get(this);
//			    	
//			        
//			        AbstractConfigScreen screen;
//		            screen = new ClothConfigScreen(parent, getTitle(), categoryMap, getDefaultBackgroundTexture()) {
//		            	
//		            };
//			        screen.setSavingRunnable(getSavingRunnable());
//			        screen.setEditable(isEditable());
//			        screen.setFallbackCategory(fallbackCategory == null ? null : Component.literal(fallbackCategory));
//			        screen.setTransparentBackground(hasTransparentBackground());
//			        screen.setAlwaysShowTabs(isAlwaysShowTabs());
//			        screen.setConfirmSave(doesConfirmSave());
//			        screen.setAfterInitConsumer(getAfterInitConsumer());
//			        return screen;
//				} catch (IllegalArgumentException | IllegalAccessException | NoSuchFieldException
//						| SecurityException e) {
//					e.printStackTrace();
//					return null;
//				}
//		    }
//		}
		ConfigBuilder builder = ConfigBuilder.create()
			.setTitle(class_2561.method_43470("Hudder"))
			.setSavingRunnable(() -> {
				try {
					config.save();
				} catch (IOException e) {
					e.printStackTrace();
					Hudder.showToast(class_2561.method_43470("Failed to save hudder config"), class_2561.method_43470(e.getMessage()));
				}
			})
			.setDefaultBackgroundTexture(class_2960.method_12829("textures/block/dark_oak_planks.png"))
			.setTransparentBackground(true)
			.setEditable(true)
			.setParentScreen(parent);
		
		ConfigEntryBuilder entryBuilder = builder.entryBuilder();
		entryBuilder.setResetButtonKey(class_2561.method_43471("hudder.reset"));
		ConfigCategory general = builder.getOrCreateCategory(class_2561.method_43471("hudder.general"));
		ConfigCategory text = builder.getOrCreateCategory(class_2561.method_43471("hudder.text"));
		ConfigCategory advanced = builder.getOrCreateCategory(class_2561.method_43471("hudder.advanced"));
		ConfigCategory variables = builder.getOrCreateCategory(class_2561.method_43471("hudder.global_variables"));
		Function<Boolean, class_2561> yesno = b->class_2561.method_43471("hudder."+b);
		
		
		/* General */
		//Why am I doing this to myself?
//		AbstractConfigListEntry<String> abstractConfigEntry = new AbstractConfigListEntry<String>(Component.literal("r"), false) {
//
//			@Override public String getValue() {return "r";}
//			@Override public List<? extends GuiEventListener> children() {return new ArrayList<GuiEventListener>();}
//			@Override public Optional<String> getDefaultValue() {return Optional.of("r");}
//			
//			ResourceLocation highlighted = ResourceLocation.withDefaultNamespace("widget/button_highlighted");
//			ResourceLocation not_highlighted = ResourceLocation.withDefaultNamespace("widget/button");
//			
//			@SuppressWarnings("unchecked") @Override public List narratables() {return new ArrayList<>();}
//			public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
//				super.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
////				context.blit(RenderType::guiTextured,ResourceLocation.withDefaultNamespace("widget/button"),
////						x, y, 0, 0f, 100, 7, entryWidth, entryHeight);
////				var b = new Button.Builder(getFieldName(), bu->{});
////				b.build().renderWidget(context, mouseX, mouseY, delta);
//				context.blitSprite(
//						RenderType::guiTextured,
//						isHovered ? highlighted : not_highlighted,
//						x,
//						y,
//						entryWidth,
//						entryHeight
//					);
//			}
//			public boolean mouseClicked(double d, double e, int i) {
//				boolean clicked = super.mouseClicked(d, e, i);
//				Hudder.log(d);
//				Hudder.log(e);
//				Hudder.log(i);
//				Hudder.log(this.isMouseOver(d, e));
//				return clicked;
//			}
//		};
//		general.addEntry(abstractConfigEntry);
		general.addEntry(entryBuilder
				.startTextDescription(class_2561.method_43471("hudder.general.folder").method_27694(s -> s
				.method_10949(new class_2568(class_2568.class_5247.field_24342, 
						class_2561.method_43471("hudder.general.folder.tooltip")))
				.method_10958(new class_2558(class_2558.class_2559.field_11748, HudFileUtils.FOLDER)))).build());
		general.addEntry(entryBuilder
				.startTextDescription(class_2561.method_43471("hudder.general.wiki").method_27694(s -> s
				.method_10949(new class_2568(class_2568.class_5247.field_24342, 
						class_2561.method_43471("hudder.general.wiki.tooltip")))
				.method_10958(new class_2558(class_2558.class_2559.field_11749, URL)))).build());
		general.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.general.enabled"),config.enabled)
				.setSaveConsumer(b->config.enabled=b)
				.setYesNoTextSupplier(yesno)
				.setTooltip(class_2561.method_43471("hudder.general.enabled.tooltip"))
				.build());
		general.addEntry(entryBuilder.startStrField(
				class_2561.method_43471("hudder.general.mainfile"), config.mainfile)
				.setTooltip(class_2561.method_43471("hudder.general.mainfile.tooltip"))
				.setDefaultValue("hud")
				.setSaveConsumer(b->config.mainfile=b)
				.setErrorSupplier(e->{
					if (!new File(HudFileUtils.FOLDER + e).exists())
						return Optional.of(class_2561.method_43471("hudder.general.mainfile.error"));
					return Optional.empty();
				})
				.build());
		general.addEntry(entryBuilder.startFloatField(class_2561.method_43471("hudder.general.scale"), config.scale)
				.setTooltip(class_2561.method_43471("hudder.general.scale.tooltip"))
				.setSaveConsumer(b->config.scale=b)
				.setDefaultValue(1f)
				.build());
		general.addEntry(entryBuilder
				.startTextDescription(class_2561.method_43471("hudder.general.folder").method_27694(s -> s
				.method_10949(new class_2568(class_2568.class_5247.field_24342, 
						class_2561.method_43471("hudder.general.folder.tooltip")))
				.method_10958(new class_2558(class_2558.class_2559.field_11746, HudFileUtils.FOLDER)))).build());
		
		
		/* Text */
		text.addEntry(entryBuilder.startColorField(class_2561.method_43471("hudder.text.color"), config.color)
				.setTooltip(class_2561.method_43471("hudder.text.color.tooltip"))
				.setAlphaMode(true)
				.setDefaultValue(0xd6d6d6)
				.setSaveConsumer(b->config.color=b)
				.build());
		text.addEntry(entryBuilder.startColorField(class_2561.method_43471("hudder.text.backgroundcolor"),
				config.backgroundcolor)
				.setTooltip(class_2561.method_43471("hudder.text.backgroundcolor.tooltip"))
				.setAlphaMode(true)
				.setDefaultValue(0x86353535)
				.setSaveConsumer(b->config.backgroundcolor=b)
				.build());
		text.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.text.background"), config.background)
				.setTooltip(class_2561.method_43471("hudder.text.background.tooltip"))
				.setSaveConsumer(b->config.background=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(true)
				.build());
		text.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.text.shadow"), config.shadow)
				.setTooltip(class_2561.method_43471("hudder.text.shadow.tooltip"))
				.setSaveConsumer(b->config.shadow=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(true)
				.build());
		text.addEntry(entryBuilder.startIntField(class_2561.method_43471("hudder.text.yoffset"), config.yoffset)
				.setTooltip(class_2561.method_43471("hudder.text.yoffset.tooltip"))
				.setSaveConsumer(b->config.yoffset=b)
				.setDefaultValue(1)
				.build());
		text.addEntry(entryBuilder.startIntField(class_2561.method_43471("hudder.text.xoffset"), config.xoffset)
				.setTooltip(class_2561.method_43471("hudder.text.xoffset.tooltip"))
				.setSaveConsumer(b->config.xoffset=b)
				.setDefaultValue(1)
				.build());
		text.addEntry(entryBuilder.startIntField(class_2561.method_43471("hudder.text.height"), config.lineHeight)
				.setTooltip(class_2561.method_43471("hudder.text.height.tooltip"))
				.setSaveConsumer(b->config.lineHeight=b)
				.setDefaultValue(10)
				.build());
		
		/* Advanced */
		advanced.addEntry(entryBuilder.startIntField(class_2561.method_43471("hudder.advanced.method"), config.methodBuffer)
				.setTooltip(class_2561.method_43471("hudder.advanced.method.tooltip"))
				.setSaveConsumer(b->config.methodBuffer=b)
				.setDefaultValue(2)
				.build());
		advanced.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.advanced.f3"), config.showInF3)
				.setTooltip(class_2561.method_43471("hudder.advanced.f3.tooltip"))
				.setSaveConsumer(b->config.showInF3=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(false)
				.build());
		advanced.addEntry(entryBuilder.startStrField(class_2561.method_43471("hudder.advanced.compilertype"), 
				config.compilertype)
	    		.setTooltip(class_2561.method_43471("hudder.advanced.compilertype.tooltip"))
	    		.setDefaultValue("hudder")
	    		.setSaveConsumer(b->config.setCompiler(b.toLowerCase()))
	    		.setErrorSupplier(e->!Compilers.has(e.toLowerCase())?
	    				Optional.of(class_2561.method_43471("hudder.advanced.compilertype.error")):Optional.empty())
	    		.build());
		advanced.addEntry(
				entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.advanced.javascript"), config.javascript)
				.setTooltip(class_2561.method_43471("hudder.advanced.javascript.tooltip"))
				.setSaveConsumer(b->config.javascript=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(false)
				.build());
		advanced.addEntry(
				entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.advanced.removehotbar"),config.removegui)
				.setTooltip(class_2561.method_43471("hudder.advanced.removehotbar.tooltip"))
				.setSaveConsumer(b->config.removegui=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(false)
				.build());
		advanced.addEntry(
				entryBuilder.startBooleanToggle(class_2561.method_43471("hudder.advanced.limitrate"),config.limitrate)
				.setTooltip(class_2561.method_43471("hudder.advanced.limitrate.tooltip"))
				.setSaveConsumer(b->config.limitrate=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(true)
				.build());
		
		
		

		variables.addEntry(entryBuilder
				.startBooleanToggle(class_2561.method_43471("hudder.global_variables"),
						config.globalVariablesEnabled)
				.setTooltip(class_2561.method_43471("hudder.global_variables.enabled.tooltip"))
				.setSaveConsumer(b->config.globalVariablesEnabled=b)
				.setYesNoTextSupplier(yesno)
				.setDefaultValue(true)
				.build());
		variables.addEntry(new NestedListListEntry<Variable, MultiElementListEntry<Variable>>(
				class_2561.method_43471("hudder.global_variables"),
                getVarList(config),
                true, 
                () -> Optional.of(new class_2561[]{class_2561.method_43471("hudder.global_variables.tooltip")}),
                this::makelist,
                () -> new ArrayList<Variable>(),
                entryBuilder.getResetButtonKey(),
                true,
                false,
                (varia, listListEntry) -> createEntry(entryBuilder, (varia!=null?varia:new Variable("","")))));
		
		return builder.build();
	}
    private List<Variable> getVarList(HudderConfig config) {
    	ArrayList<Variable> lst = new ArrayList<Variable>();
    	for (Map.Entry<String, Object> v : config.globalVariables.entrySet())
    		lst.add(new Variable(v.getKey(),v.getValue()));
		return lst;
	}
	private static MultiElementListEntry<Variable> createEntry(ConfigEntryBuilder entryBuilder, Variable variable) {
		return new MultiElementListEntry<Variable>(
			class_2561.method_43472(!"".equals(variable.key) ? variable.key : "Variable" ),
            variable,
            Arrays.asList(
                entryBuilder.startTextField(
                		class_2561.method_43471("hudder.global_variables.key"),
                        variable.key)
                    .setTooltip(class_2561.method_43471("hudder.global_variables.key.tooltip"))
                    .setSaveConsumer(name -> variable.key = name)
                    .build(),
                entryBuilder.startStrField(
                		class_2561.method_43471("hudder.global_variables.value"),
                        variable.value.toString())
                    .setTooltip(class_2561.method_43471("hudder.global_variables.value.tooltip"))
                    .setSaveConsumer(value -> variable.value = value)
                    .build()
            ),
            true);
    }
    
    public static class Variable {
    	public Variable(String key, Object value) {this.key=key;this.value=value;}
		public String key;
    	public Object value;
    }

	private void makelist(List<Variable> list) {
		Hudder.config.globalVariables = new HashMap<String,Object>();
		for (Variable l : list) Hudder.config.globalVariables.put(l.key, l.value);
	}
}
