package io.github.ngspace.hudder.uielements;

import io.github.ngspace.hudder.main.HudderRenderer;
import io.github.ngspace.hudder.mixin.InGameHudAccessor;
import net.minecraft.class_1316;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9779;

/**
 * This element is a merging of all builtin GUI elements (Status bars) 
 * with the goal of allowing the creation of a custom
 * game hud without forcing the user to reimplement every single UI Element themselves
 */
public class GameHudElement extends AUIElement {
	
	protected static class_310 mc = class_310.method_1551();
	public enum GuiType {
		STATUS_BARS,
		EXP_AND_MOUNT_BAR,
		HOTBAR,
		ITEM_TOOLTIP;
	}
	
	public final int x;
	public final int y;
	public final GuiType type;
	
	public GameHudElement(int x, int y, GuiType type) {
		this.x = x;
		this.y = y;
		this.type = type;
	}

	@Override public void renderElement(class_332 context, HudderRenderer renderer, class_9779 delta) {
		try {
			InGameHudAccessor acchud = (InGameHudAccessor) (mc.field_1705);
			float scaledWidth = context.method_51421();
	        float scaledHeight = context.method_51443();
	        class_4587 matrixStack = context.method_51448();
	        matrixStack.method_22903();
	        switch (type) {
				case STATUS_BARS:
			        if (mc.field_1761.method_2908()) {
				        matrixStack.method_46416(x-scaledWidth/2, y-scaledHeight + 39, 0f);
				        acchud.callRenderPlayerHealth(context);
				        acchud.callRenderVehicleHealth(context);
			        }
			        break;
				case EXP_AND_MOUNT_BAR:
		            int i = (int) (scaledWidth / 2 - 91);
			    	class_1316 jumpingMount = mc.field_1724.method_45773();
		            if (jumpingMount != null) {
				        matrixStack.method_46416(x-scaledWidth/2, y-scaledHeight + 39, 0f);
				        acchud.callRenderJumpMeter(jumpingMount, context, i);
		            } else if (mc.field_1761.method_2913()) {
				        matrixStack.method_46416(x-scaledWidth/2, y-scaledHeight + 35, 0f);
				        class_327 font = mc.field_1772;
			    		int jj = mc.field_1724.field_7520;
			    		if (mc.field_1761.method_2913() && jj > 0) {
			    			String string = "" + jj;
			    			int j = (context.method_51421() - font.method_1727(string)) / 2;
			    			int k = context.method_51443() - 31 - 8;
			    			context.method_51433(font, string, j + 1, k, 0, false);
			    			context.method_51433(font, string, j - 1, k, 0, false);
			    			context.method_51433(font, string, j, k + 1, 0, false);
			    			context.method_51433(font, string, j, k - 1, 0, false);
			    			context.method_51433(font, string, j, k, 8453920, false);
			    		}
				        acchud.callRenderExperienceBar(context, i);
		            }
					break;
				case HOTBAR:
			        matrixStack.method_46416(x-scaledWidth/2, y-scaledHeight, 0f);
			        acchud.callRenderItemHotbar(context, delta);
					break;
				case ITEM_TOOLTIP:
					int tooltipy = 44;
					if (mc.field_1761.method_2908()) tooltipy -= 14;
			        matrixStack.method_46416(x-scaledWidth/2, tooltipy-scaledHeight+y, 0f);
			        acchud.callRenderSelectedItemName(context);
					break;
				default:
					break;
			}
	        matrixStack.method_22909();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
