/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.HudderUtils;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.runtime_elements.BreakV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.ConditionV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.ForV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.IfV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.MethodV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.ReturnV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.StringV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.VariableV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.runtime_elements.WhileV2RuntimeElement;
import java.util.Arrays;

public class HudderV2Compiler
extends AV2Compiler {
    public static final int TEXT_STATE = 0;
    public static final int VARIABLE_STATE = 1;
    public static final int CONDITION_STATE = 2;
    public static final int METHOD_STATE = 3;
    public static final int HASHTAG_STATE = 4;

    /*
     * Unable to fully structure code
     */
    @Override
    public V2Runtime buildRuntime(HudderConfig info, String text, ATextCompiler.CharPosition charPosition, String filename, V2Runtime scope) throws CompileException {
        runtime = new V2Runtime(this, scope);
        elemBuilder = new StringBuilder();
        bracketscount = 0;
        builder = new String[]{};
        quotesafe = false;
        backslashsafe = false;
        condSafe = false;
        safeappend = false;
        savedind = 0;
        cleanup = false;
        cleanup_amount = Hudder.config.methodBuffer;
        compileState = 0;
        block30: for (ind = 0; ind < text.length(); ++ind) {
            c = text.charAt(ind);
            switch (compileState) {
                case 0: {
                    if (cleanup && cleanup_amount > 0 && cleanup_amount < 10) {
                        --cleanup_amount;
                        if (c == '\n' || c == '\r') continue block30;
                        cleanup = false;
                    } else {
                        cleanup = false;
                    }
                    if (safeappend) {
                        elemBuilder.append(c);
                        safeappend = safeappend == false;
                        continue block30;
                    }
                    switch (c) {
                        case '%': {
                            compileState = 2;
                            builder = new String[]{};
                            runtime.addRuntimeElement(new StringV2RuntimeElement(elemBuilder.toString(), false));
                            elemBuilder.setLength(0);
                            savedind = ind;
                            continue block30;
                        }
                        case '{': {
                            compileState = 1;
                            runtime.addRuntimeElement(new StringV2RuntimeElement(elemBuilder.toString(), false));
                            elemBuilder.setLength(0);
                            bracketscount = 1;
                            savedind = ind;
                            continue block30;
                        }
                        case ';': {
                            compileState = 3;
                            runtime.addRuntimeElement(new StringV2RuntimeElement(elemBuilder.toString(), true));
                            elemBuilder.setLength(0);
                            builder = new String[]{};
                            savedind = ind;
                            continue block30;
                        }
                        case '#': {
                            compileState = 4;
                            builder = new String[]{};
                            runtime.addRuntimeElement(new StringV2RuntimeElement(elemBuilder.toString(), false));
                            elemBuilder.setLength(0);
                            savedind = ind;
                            continue block30;
                        }
                        case '&': {
                            elemBuilder.append('\u00a7');
                            continue block30;
                        }
                        case '\\': {
                            safeappend = true;
                            continue block30;
                        }
                    }
                    elemBuilder.append(c);
                    continue block30;
                }
                case 1: {
                    if (c == '\"') {
                        prevchar = 92;
                        while (ind < text.length()) {
                            c = text.charAt(ind);
                            if (prevchar != 92 && c == '\"') break;
                            elemBuilder.append(c);
                            prevchar = c;
                            ++ind;
                        }
                    }
                    if (c == '{') {
                        ++bracketscount;
                        elemBuilder.append(c);
                        continue block30;
                    }
                    if (c == '}') {
                        if (--bracketscount == 0) {
                            pos = this.getPosition(charPosition, savedind, text);
                            if ("break".equalsIgnoreCase(elemBuilder.toString().trim())) {
                                runtime.addRuntimeElement(new BreakV2RuntimeElement());
                            } else {
                                runtime.addRuntimeElement(new VariableV2RuntimeElement(elemBuilder.toString(), this, runtime, pos.line, pos.charpos));
                            }
                            elemBuilder.setLength(0);
                            compileState = 0;
                            continue block30;
                        }
                        elemBuilder.append(c);
                        continue block30;
                    }
                    elemBuilder.append(c);
                    continue block30;
                }
                case 2: {
                    if (c == '\\') {
                        if (condSafe) {
                            elemBuilder.append('\\');
                            condSafe = false;
                            continue block30;
                        }
                        condSafe = true;
                        continue block30;
                    }
                    if (quotesafe && c != '\"') {
                        elemBuilder.append(c);
                        continue block30;
                    }
                    if (condSafe && c == '\"') {
                        elemBuilder.append('\\');
                        elemBuilder.append(c);
                        condSafe = false;
                        continue block30;
                    }
                    if (condSafe) {
                        elemBuilder.append(c);
                        condSafe = false;
                        continue block30;
                    }
                    switch (c) {
                        case '%': {
                            compileState = 0;
                            builder = HudderV2Compiler.addToArray(builder, elemBuilder.toString().trim());
                            pos = this.getPosition(charPosition, savedind, text);
                            runtime.addRuntimeElement(new ConditionV2RuntimeElement(builder, this, info, runtime, pos.line, pos.charpos, filename));
                            elemBuilder.setLength(0);
                            continue block30;
                        }
                        case '\"': {
                            quotesafe = quotesafe == false;
                            elemBuilder.append(c);
                            continue block30;
                        }
                        case ',': {
                            builder = HudderV2Compiler.addToArray(builder, elemBuilder.toString().trim());
                            elemBuilder.setLength(0);
                            continue block30;
                        }
                    }
                    elemBuilder.append(c);
                    continue block30;
                }
                case 3: {
                    if (backslashsafe) {
                        backslashsafe = false;
                        elemBuilder.append(c);
                        continue block30;
                    }
                    switch (c) {
                        case '\\': {
                            backslashsafe = true;
                            elemBuilder.append(c);
                            break;
                        }
                        case '\"': {
                            quotesafe = quotesafe == false;
                            elemBuilder.append(c);
                            break;
                        }
                        case ';': {
                            if (!quotesafe) {
                                compileState = 0;
                                break;
                            }
                            elemBuilder.append(c);
                            break;
                        }
                        default: {
                            elemBuilder.append(c);
                        }
                    }
                    if (compileState == 3) continue block30;
                    builder = HudderUtils.processParemeters(elemBuilder.toString());
                    pos = this.getPosition(charPosition, savedind, text);
                    line = pos.line;
                    charpos = pos.charpos;
                    if (builder[0].toLowerCase().trim().equals("no_sys_var")) {
                        this.SYSTEM_VARIABLES_ENABLED = false;
                    } else if (builder[0].toLowerCase().trim().equals("sys_var")) {
                        this.SYSTEM_VARIABLES_ENABLED = true;
                    } else if (builder.length == 2 && builder[0].toLowerCase().trim().equals("return")) {
                        runtime.addRuntimeElement(new ReturnV2RuntimeElement(builder[1], this, runtime, line, charpos));
                    } else {
                        runtime.addRuntimeElement(new MethodV2RuntimeElement(builder, this, info, runtime, line, charpos));
                    }
                    elemBuilder.setLength(0);
                    builder = new String[]{};
                    cleanup = true;
                    cleanup_amount = Hudder.config.methodBuffer / 2;
                    continue block30;
                }
                case 4: {
                    command = 0;
                    compileState = 0;
                    while (ind < text.length() && (c = text.charAt(ind)) != '\n') {
                        if (command != 0) ** GOTO lbl-1000
                        if (c == ' ' && elemBuilder.toString().equals("while")) {
                            command = 2;
                        } else if (c == ' ' && elemBuilder.toString().equals("if")) {
                            command = 1;
                        } else if (c == ' ' && elemBuilder.toString().equals("def")) {
                            command = 3;
                        } else if (c == ' ' && elemBuilder.toString().equals("for")) {
                            command = 4;
                        }
                        if (command != 0) {
                            elemBuilder.setLength(0);
                        } else lbl-1000:
                        // 2 sources

                        {
                            elemBuilder.append(c);
                        }
                        ++ind;
                    }
                    cond = elemBuilder.toString();
                    elemBuilder.setLength(0);
                    instructions = new StringBuilder();
                    if (ind + 1 < text.length() && (text.charAt(ind + 1) == '\t' || text.charAt(ind + 1) == ' ')) {
                        initalIndent = this.checkIndentation(text, ++ind);
                        while (ind < text.length()) {
                            if (ind + 1 < text.length()) {
                                indent = this.checkIndentation(text, ind);
                                if (!indent.startsWith(initalIndent)) break;
                                ind += initalIndent.length();
                                while (ind < text.length()) {
                                    c = text.charAt(ind);
                                    instructions.append(c);
                                    if (c == '\n') break;
                                    ++ind;
                                }
                            }
                            ++ind;
                        }
                        --ind;
                    }
                    if (ind != text.length() && text.charAt(ind) != '\n' && text.charAt(ind) != '\r') {
                        --ind;
                    }
                    cmds = instructions.toString();
                    pos = this.getPosition(charPosition, savedind + 1, "\n" + text);
                    switch (command) {
                        case 4: {
                            split = cond.split(" in ", 2);
                            variablename = split[0];
                            value = split[1];
                            elemBuilder.setLength(0);
                            runtime.addRuntimeElement(new ForV2RuntimeElement(info, variablename, value, cmds, this, runtime, pos, filename));
                            continue block30;
                        }
                        case 3: {
                            builder = HudderUtils.processParemeters(cond);
                            name = builder[0];
                            args = Arrays.copyOfRange(builder, 1, builder.length);
                            this.defineFunctionOrMethod(cmds, args, name, pos, filename);
                            elemBuilder.setLength(0);
                            continue block30;
                        }
                        case 2: {
                            runtime.addRuntimeElement(new WhileV2RuntimeElement(info, cond, cmds, this, runtime, pos, filename));
                            continue block30;
                        }
                    }
                    runtime.addRuntimeElement(new IfV2RuntimeElement(info, cond, cmds, this, runtime, pos, filename));
                    continue block30;
                }
                default: {
                    throw new CompileException("Unknown compile state: " + (byte)compileState);
                }
            }
        }
        runtime.addRuntimeElement(new StringV2RuntimeElement(elemBuilder.toString(), false));
        if (compileState != 0) {
            throw new CompileException(this.getCompilerErrorMessage(compileState));
        }
        return runtime;
    }

    private String checkIndentation(String text, int index) {
        char c;
        StringBuilder b = new StringBuilder();
        while (index < text.length() && ((c = text.charAt(index)) == ' ' || c == '\t')) {
            b.append(c);
            ++index;
        }
        return b.toString();
    }

    public String getCompilerErrorMessage(int compileState) {
        StringBuilder strb = new StringBuilder();
        strb.append(switch (compileState) {
            case 1 -> "Expected '}'";
            case 2 -> "Expected '%'";
            case 3 -> "Expected ';'";
            case 4 -> "Expected end of ADVANCED_CONDITION_STATE";
            default -> "An unknown error has occurred";
        });
        return strb.toString();
    }

    private static <T> T[] addToArray(T[] arr, T t) {
        T[] newarr = Arrays.copyOf(arr, arr.length + 1);
        newarr[arr.length] = t;
        return newarr;
    }
}

