/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.abstractions;

import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.abstractions.AVarTextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.compilers.utils.functionandconsumerapi.FunctionAndConsumerAPI;
import io.github.ngspace.hudder.main.HudCompilationManager;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.ObjectWrapper;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.functions.V2FunctionHandler;
import io.github.ngspace.hudder.v2runtime.methods.MethodHandler;
import io.github.ngspace.hudder.v2runtime.runtime_elements.AV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import io.github.ngspace.hudder.v2runtime.values.DefaultV2VariableParser;
import io.github.ngspace.hudder.v2runtime.values.IV2VariableParser;
import java.util.HashMap;
import java.util.Map;

public abstract class AV2Compiler
extends AVarTextCompiler
implements FunctionAndConsumerAPI.Binder {
    public Map<String, V2Runtime> runtimes = new HashMap<String, V2Runtime>();
    public Map<String, Object> tempVariables = new HashMap<String, Object>();
    public MethodHandler methodHandler = new MethodHandler();
    public V2FunctionHandler functionHandler = new V2FunctionHandler();
    protected IV2VariableParser variableParser = new DefaultV2VariableParser();
    public boolean SYSTEM_VARIABLES_ENABLED = true;
    public V2Runtime globalRuntime = null;

    protected AV2Compiler() {
        HudCompilationManager.addPreCompilerListener(c -> {
            this.globalRuntime = null;
            this.tempVariables.clear();
        });
        FunctionAndConsumerAPI.getInstance().applyFunctionsAndConsumers(this);
    }

    public Object getTempVariable(String key) {
        return this.tempVariables.get(key);
    }

    public void putTemp(String key, Object value) {
        this.tempVariables.put(key, value);
    }

    public AV2Value getV2Value(V2Runtime runtime, String string, int line, int col) throws CompileException {
        return this.getVariableParser().parse(runtime, string, this, line, col);
    }

    public IV2VariableParser getVariableParser() {
        return this.variableParser;
    }

    public void setVariableParser(IV2VariableParser parser) {
        this.variableParser = parser;
    }

    @Override
    public final HudInformation compile(HudderConfig info, String text, String filename) throws CompileException {
        V2Runtime runtime = this.runtimes.get(text);
        if (runtime == null) {
            runtime = this.buildRuntime(info, text, new ATextCompiler.CharPosition(-1, -1), filename, null);
            this.runtimes.put(text, runtime);
        }
        if (this.globalRuntime == null) {
            this.globalRuntime = runtime;
        }
        return runtime.execute().toResult();
    }

    public abstract V2Runtime buildRuntime(HudderConfig var1, String var2, ATextCompiler.CharPosition var3, String var4, V2Runtime var5) throws CompileException;

    @Override
    public void bindConsumer(FunctionAndConsumerAPI.BindableConsumer cons, String ... names) {
        this.methodHandler.bindConsumer((HudderConfig c, CompileState m, ATextCompiler a, String t, int l, int ch, ObjectWrapper[] s) -> cons.invoke(m, this, s), names);
    }

    @Override
    public void bindFunction(FunctionAndConsumerAPI.BindableFunction cons, String ... names) {
        this.functionHandler.bindFunction((V2Runtime c, String a, AV2Value[] s, int l, int ch) -> cons.invoke(c.compileState, this, s), names);
    }

    public void defineFunctionOrMethod(String commands, String[] args, String name, ATextCompiler.CharPosition pos, String filename) throws CompileException {
        boolean isMethod;
        V2Runtime runtime = this.buildRuntime(this.getConfig(), commands, pos, filename, null);
        boolean bl = isMethod = !this.hasReturnValue(runtime);
        if (isMethod) {
            MethodHandler.methods.put(name, (info, state, comp, type, line, charpos, vals) -> {
                if (vals.length < args.length) {
                    throw new CompileException("Not enough arguments", pos.line, pos.charpos);
                }
                for (int i = 0; i < vals.length; ++i) {
                    Object v = vals[i].get();
                    runtime.putScoped("arg" + (i + 1), v);
                    runtime.putScoped(args[i].trim(), v);
                }
                try {
                    state.combineWithResult(runtime.execute().toResult(), false);
                }
                catch (CompileException e) {
                    throw new CompileException("Method " + type + " threw an error: \n" + e.getFailureMessage(), line, charpos);
                }
            });
        } else {
            boolean temp = true;
            for (AV2RuntimeElement element : runtime.getElements()) {
                if (!element.returnsAValue()) continue;
                temp = false;
            }
            if (temp) {
                throw new CompileException("Main path in function \"" + name + "\" does not return a value!", pos.line, pos.charpos);
            }
            this.functionHandler.bindFunction((V2Runtime funcruntime, String funcname, AV2Value[] vals, int line, int charpos) -> {
                if (vals.length < args.length) {
                    throw new CompileException("Not enough arguments", pos.line, pos.charpos);
                }
                for (int i = 0; i < vals.length; ++i) {
                    Object v = vals[i].get();
                    runtime.putScoped("arg" + (i + 1), v);
                    runtime.putScoped(args[i].trim(), v);
                }
                try {
                    CompileState exec = runtime.execute();
                    runtime.compileState.combineWithResult(exec.toResult(), false);
                    return exec.returnValue;
                }
                catch (CompileException e) {
                    throw new CompileException("Method " + name + " threw an error: \n" + e.getFailureMessage(), line, charpos);
                }
            }, name);
        }
    }

    public boolean hasReturnValue(V2Runtime runtime) {
        for (AV2RuntimeElement element : runtime.getElements()) {
            if (element.returnsAValue()) {
                return true;
            }
            if (element.getNestedRuntime() == null || !this.hasReturnValue(element.getNestedRuntime())) continue;
            return true;
        }
        return false;
    }
}

