/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.utils.ObjectWrapper;
import java.util.Collection;
import java.util.Objects;

public abstract class AV2Value
implements ObjectWrapper {
    protected final int line;
    protected final int charpos;
    public final String value;
    protected final AV2Compiler compiler;
    protected CompileState state;

    protected AV2Value(int line, int charpos, String debugvalue, AV2Compiler compiler, CompileState state) {
        this.line = line;
        this.charpos = charpos;
        this.value = debugvalue;
        this.compiler = compiler;
        this.state = state;
    }

    protected AV2Value(int line, int charpos, String debugvalue, AV2Compiler compiler) {
        this(line, charpos, debugvalue, compiler, null);
    }

    public boolean compare(AV2Value other, String comparisonOperator) throws CompileException {
        boolean otherhasval;
        Number num;
        Object val1 = this.get();
        Object val2 = other.get();
        if (!other.hasValue() || !this.hasValue()) {
            if (comparisonOperator.equals("==")) {
                return other.hasValue() == this.hasValue();
            }
            if (comparisonOperator.equals("!=")) {
                return other.hasValue() != this.hasValue();
            }
            throw new CompileException("Can not compare null values using the " + comparisonOperator + " operator.");
        }
        boolean areNums = false;
        double dou1 = 0.0;
        double dou2 = 0.0;
        if (val1 instanceof Number) {
            num = (Number)val1;
            dou1 = num.doubleValue();
            otherhasval = other.hasValue();
            if (!otherhasval) {
                dou2 = other.asDouble();
            }
            if (val2 instanceof Number || !otherhasval) {
                areNums = true;
            }
        }
        if (val2 instanceof Number) {
            num = (Number)val2;
            dou2 = num.doubleValue();
            otherhasval = this.hasValue();
            if (!otherhasval) {
                dou1 = this.asDouble();
            }
            if (val1 instanceof Number || !otherhasval) {
                areNums = true;
            }
        }
        return switch (comparisonOperator) {
            case "==" -> {
                if (areNums) {
                    if (dou1 == dou2) {
                        yield true;
                    }
                    yield false;
                }
                yield Objects.equals(val1, val2);
            }
            case "!=" -> {
                if (areNums) {
                    if (dou1 != dou2) {
                        yield true;
                    }
                    yield false;
                }
                if (!Objects.equals(val1, val2)) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (dou1 >= dou2) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (dou1 <= dou2) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (dou1 > dou2) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (dou1 < dou2) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unknown comparasion operator: " + comparisonOperator);
        };
    }

    @Override
    public boolean asBoolean() throws CompileException {
        return this.asType(Boolean.class);
    }

    @Override
    public double asDouble() throws CompileException {
        return this.asType(Number.class).doubleValue();
    }

    @Override
    public String asString() throws CompileException {
        return this.asType(String.class);
    }

    @Override
    public Object[] asArray() throws CompileException {
        Object get = this.get();
        if (get instanceof Collection) {
            Collection c = (Collection)get;
            return c.toArray();
        }
        return (Object[])get;
    }

    @Override
    public <T> T asType(Class<T> clazz) throws CompileException {
        Object get = this.get();
        if (clazz.isInstance(get)) {
            return clazz.cast(get);
        }
        throw new CompileException(AV2Value.invalidTypeMessage(clazz.getSimpleName(), this.value, get), this.line, this.charpos);
    }

    public static String invalidTypeMessage(String type, String value, Object obj) {
        return "Incorrect type \"" + type + "\" for value: \"" + value + "\" of type " + obj.getClass().getName();
    }

    public abstract void setValue(AV2Compiler var1, Object var2) throws CompileException, UnsupportedOperationException;

    public boolean hasValue() throws CompileException {
        return true;
    }

    public abstract boolean isConstant() throws CompileException;

    @Override
    public String toString() {
        return this.value;
    }
}

