/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.utils.functionandconsumerapi;

import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.functionandconsumerapi.IUIElementManager;
import io.github.ngspace.hudder.data_management.ComponentsData;
import io.github.ngspace.hudder.utils.ObjectWrapper;
import io.github.ngspace.hudder.utils.ValueGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_9323;

public class FunctionAndConsumerAPI {
    static FunctionAndConsumerAPI instance = new FunctionAndConsumerAPI();
    HashMap<BindableFunction, String[]> functions = new HashMap();
    HashMap<BindableConsumer, String[]> consumers = new HashMap();
    List<Binder> binders = new ArrayList<Binder>();

    public void applyFunctionsAndConsumers(Binder binder) {
        for (Map.Entry<BindableConsumer, String[]> entry : this.consumers.entrySet()) {
            binder.bindConsumer(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, String[]> entry : this.functions.entrySet()) {
            System.out.println(entry.getValue());
            binder.bindFunction((BindableFunction)entry.getKey(), entry.getValue());
        }
        this.binders.add(binder);
    }

    public void registerFunction(BindableFunction func, String ... names) {
        for (Binder binder : this.binders) {
            binder.bindFunction(func, names);
        }
        this.functions.put(func, names);
    }

    public void registerConsumer(BindableConsumer func, String ... names) {
        for (Binder binder : this.binders) {
            binder.bindConsumer(func, names);
        }
        this.consumers.put(func, names);
    }

    public static FunctionAndConsumerAPI getInstance() {
        return instance;
    }

    @FunctionalInterface
    public static interface BindableConsumer {
        public void invoke(IUIElementManager var1, ATextCompiler var2, ObjectWrapper ... var3) throws CompileException;
    }

    public static interface Binder {
        public void bindConsumer(BindableConsumer var1, String ... var2);

        public void bindFunction(BindableFunction var1, String ... var2);
    }

    @FunctionalInterface
    public static interface BindableFunction {
        public Object invoke(IUIElementManager var1, ATextCompiler var2, ObjectWrapper ... var3) throws CompileException;
    }

    public static class TranslatedItemStack
    implements ValueGetter {
        public String name;
        public int count;
        public int maxcount;
        public int durability;
        public int maxdurability;
        private class_9323 components;

        public TranslatedItemStack(class_1799 stack) {
            this.name = stack.method_7954().getString();
            this.count = stack.method_7947();
            this.maxcount = stack.method_7914();
            this.durability = stack.method_7936() - stack.method_7919();
            this.maxdurability = stack.method_7936();
            this.components = stack.method_57353();
        }

        public String toString() {
            return "{name:\"" + this.name + "\", count:" + this.count + ", maxcount: " + this.maxcount + ", durability: " + this.durability + ", maxdurability: " + this.maxdurability + "}";
        }

        @Override
        public Object get(String component) {
            return ComponentsData.getObject(component, this.components);
        }
    }
}

