/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.main.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.Compilers;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.HudFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.gui.entries.NestedListListEntry;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ConfigMenu
implements ConfigScreenFactory<class_437> {
    protected static class_310 mc = class_310.method_1551();
    public static final String URL = "https://ngspace.github.io/hudder";

    public class_437 create(class_437 parent) {
        HudderConfig config = Hudder.config;
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43470((String)"Hudder")).setSavingRunnable(() -> {
            try {
                config.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                Hudder.showToast((class_2561)class_2561.method_43470((String)"Failed to save hudder config"), (class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        }).setDefaultBackgroundTexture(class_2960.method_12829((String)"textures/block/dark_oak_planks.png")).setTransparentBackground(true).setEditable(true).setParentScreen(parent);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        entryBuilder.setResetButtonKey((class_2561)class_2561.method_43471((String)"hudder.reset"));
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"hudder.general"));
        ConfigCategory text = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"hudder.text"));
        ConfigCategory advanced = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"hudder.advanced"));
        ConfigCategory variables = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"hudder.global_variables"));
        Function<Boolean, class_2561> yesno = b -> class_2561.method_43471((String)("hudder." + b));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"hudder.general.folder").method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"hudder.general.folder.tooltip"))).method_10958(new class_2558(class_2558.class_2559.field_11748, HudFileUtils.FOLDER)))).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"hudder.general.wiki").method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"hudder.general.wiki.tooltip"))).method_10958(new class_2558(class_2558.class_2559.field_11749, URL)))).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.general.enabled"), config.enabled).setSaveConsumer(b -> {
            config.enabled = b;
        }).setYesNoTextSupplier(yesno).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.general.enabled.tooltip")}).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43471((String)"hudder.general.mainfile"), config.mainfile).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.general.mainfile.tooltip")}).setDefaultValue("hud").setSaveConsumer(b -> {
            config.mainfile = b;
        }).setErrorSupplier(e -> {
            if (!new File(HudFileUtils.FOLDER + e).exists()) {
                return Optional.of(class_2561.method_43471((String)"hudder.general.mainfile.error"));
            }
            return Optional.empty();
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43471((String)"hudder.general.scale"), config.scale).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.general.scale.tooltip")}).setSaveConsumer(b -> {
            config.scale = b.floatValue();
        }).setDefaultValue(1.0f).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"hudder.general.folder").method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"hudder.general.folder.tooltip"))).method_10958(new class_2558(class_2558.class_2559.field_11746, HudFileUtils.FOLDER)))).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startColorField((class_2561)class_2561.method_43471((String)"hudder.text.color"), config.color).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.color.tooltip")}).setAlphaMode(true).setDefaultValue(0xD6D6D6).setSaveConsumer(b -> {
            config.color = b;
        }).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startColorField((class_2561)class_2561.method_43471((String)"hudder.text.backgroundcolor"), config.backgroundcolor).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.backgroundcolor.tooltip")}).setAlphaMode(true).setDefaultValue(-2043333323).setSaveConsumer(b -> {
            config.backgroundcolor = b;
        }).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.text.background"), config.background).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.background.tooltip")}).setSaveConsumer(b -> {
            config.background = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(true).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.text.shadow"), config.shadow).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.shadow.tooltip")}).setSaveConsumer(b -> {
            config.shadow = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(true).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"hudder.text.yoffset"), config.yoffset).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.yoffset.tooltip")}).setSaveConsumer(b -> {
            config.yoffset = b;
        }).setDefaultValue(1).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"hudder.text.xoffset"), config.xoffset).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.xoffset.tooltip")}).setSaveConsumer(b -> {
            config.xoffset = b;
        }).setDefaultValue(1).build());
        text.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"hudder.text.height"), config.lineHeight).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.text.height.tooltip")}).setSaveConsumer(b -> {
            config.lineHeight = b;
        }).setDefaultValue(10).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"hudder.advanced.method"), config.methodBuffer).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.method.tooltip")}).setSaveConsumer(b -> {
            config.methodBuffer = b;
        }).setDefaultValue(2).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.advanced.f3"), config.showInF3).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.f3.tooltip")}).setSaveConsumer(b -> {
            config.showInF3 = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(false).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43471((String)"hudder.advanced.compilertype"), config.compilertype).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.compilertype.tooltip")}).setDefaultValue("hudder").setSaveConsumer(b -> config.setCompiler(b.toLowerCase())).setErrorSupplier(e -> !Compilers.has(e.toLowerCase()) ? Optional.of(class_2561.method_43471((String)"hudder.advanced.compilertype.error")) : Optional.empty()).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.advanced.javascript"), config.javascript).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.javascript.tooltip")}).setSaveConsumer(b -> {
            config.javascript = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(false).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.advanced.removehotbar"), config.removegui).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.removehotbar.tooltip")}).setSaveConsumer(b -> {
            config.removegui = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(false).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.advanced.limitrate"), config.limitrate).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.advanced.limitrate.tooltip")}).setSaveConsumer(b -> {
            config.limitrate = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(true).build());
        variables.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"hudder.global_variables"), config.globalVariablesEnabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.global_variables.enabled.tooltip")}).setSaveConsumer(b -> {
            config.globalVariablesEnabled = b;
        }).setYesNoTextSupplier(yesno).setDefaultValue(true).build());
        variables.addEntry((AbstractConfigListEntry)new NestedListListEntry((class_2561)class_2561.method_43471((String)"hudder.global_variables"), this.getVarList(config), true, () -> Optional.of(new class_2561[]{class_2561.method_43471((String)"hudder.global_variables.tooltip")}), this::makelist, () -> new ArrayList(), entryBuilder.getResetButtonKey(), true, false, (varia, listListEntry) -> ConfigMenu.createEntry(entryBuilder, varia != null ? varia : new Variable("", ""))));
        return builder.build();
    }

    private List<Variable> getVarList(HudderConfig config) {
        ArrayList<Variable> lst = new ArrayList<Variable>();
        for (Map.Entry<String, Object> v : config.globalVariables.entrySet()) {
            lst.add(new Variable(v.getKey(), v.getValue()));
        }
        return lst;
    }

    private static MultiElementListEntry<Variable> createEntry(ConfigEntryBuilder entryBuilder, Variable variable) {
        return new MultiElementListEntry((class_2561)class_2561.method_43472((String)(!"".equals(variable.key) ? variable.key : "Variable")), (Object)variable, Arrays.asList(entryBuilder.startTextField((class_2561)class_2561.method_43471((String)"hudder.global_variables.key"), variable.key).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.global_variables.key.tooltip")}).setSaveConsumer(name -> {
            variable.key = name;
        }).build(), entryBuilder.startStrField((class_2561)class_2561.method_43471((String)"hudder.global_variables.value"), variable.value.toString()).setTooltip(new class_2561[]{class_2561.method_43471((String)"hudder.global_variables.value.tooltip")}).setSaveConsumer(value -> {
            variable.value = value;
        }).build()), true);
    }

    private void makelist(List<Variable> list) {
        Hudder.config.globalVariables = new HashMap<String, Object>();
        for (Variable l : list) {
            Hudder.config.globalVariables.put(l.key, l.value);
        }
    }

    public static class Variable {
        public String key;
        public Object value;

        public Variable(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

