/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.operations;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.utils.HudderUtils;
import io.github.ngspace.hudder.utils.NoAccess;
import io.github.ngspace.hudder.utils.ValueGetter;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.mozilla.javascript.ScriptableObject;

public class V2ClassPropertyCall
extends AV2Value {
    private static final String[] forbiddenValuesAndFunctions = new String[]{"getClass", "hashCode", "wait", "notify", "notifyAll", "clone", "finalize"};
    private AV2Value classobj;
    private boolean isFunctionCall;
    private AV2Value[] functionCallArgs;
    private String funcName = "";
    private String fieldName = "";

    public V2ClassPropertyCall(int line, int charpos, String value, AV2Compiler c, V2Runtime runtime, AV2Value classobj, String prop) throws CompileException {
        super(line, charpos, value, c);
        int argStart;
        this.classobj = classobj;
        if (!prop.startsWith("(") && prop.endsWith(")") && (argStart = prop.indexOf("(")) != -1) {
            this.funcName = prop.substring(0, argStart);
            if (this.funcName.matches("^[a-zA-Z0-9_-]*$")) {
                String parametersString = prop.substring(argStart + 1, prop.length() - 1);
                String[] tokenizedArgs = HudderUtils.processParemeters(parametersString);
                this.functionCallArgs = new AV2Value[tokenizedArgs.length];
                for (int i = 0; i < this.functionCallArgs.length; ++i) {
                    this.functionCallArgs[i] = c.getV2Value(runtime, tokenizedArgs[i], line, charpos);
                }
                this.isFunctionCall = true;
            }
        }
        if (!this.isFunctionCall) {
            this.fieldName = prop;
        }
        for (String forbidden : forbiddenValuesAndFunctions) {
            if (forbidden.equals(this.funcName)) {
                throw new CompileException("No function named \"" + this.funcName + "\"", line, charpos);
            }
            if (!forbidden.equals(this.fieldName)) continue;
            throw new CompileException("No property named \"" + this.fieldName + "\"", line, charpos);
        }
    }

    @Override
    public Object get() throws CompileException {
        Object obj = this.smartGet();
        if (obj instanceof Set) {
            Set r = (Set)obj;
            return r.toArray();
        }
        if (obj instanceof ScriptableObject) {
            final ScriptableObject en = (ScriptableObject)obj;
            return new ValueGetter(){

                @Override
                public Object get(String n) {
                    return en.get(n);
                }

                public String toString() {
                    return en.toString();
                }
            };
        }
        return obj;
    }

    public Object smartGet() throws CompileException {
        Object objValue = this.classobj.get();
        if (V2Runtime.NULL.equals(objValue)) {
            throw new CompileException("Can't read \"" + this.funcName + this.fieldName + "\" because \"" + this.classobj.value + "\" is null", this.line, this.charpos);
        }
        Class<?> objClass = objValue.getClass();
        if (objClass.isPrimitive()) {
            throw new CompileException("Can not read properties of Numbers, Booleans and Chars : " + this.classobj.value, this.line, this.charpos);
        }
        if (this.isFunctionCall) {
            Object[] parameters = new Object[this.functionCallArgs.length];
            Class[] classes = new Class[this.functionCallArgs.length];
            for (int i = 0; i < this.functionCallArgs.length; ++i) {
                parameters[i] = this.functionCallArgs[i].get();
                classes[i] = parameters[i].getClass();
            }
            Object[] finalParameters = Arrays.copyOf(parameters, parameters.length);
            Method finalmethod = null;
            for (Method method : objClass.getMethods()) {
                if (!this.funcName.equals(method.getName()) || method.getParameterCount() != classes.length || !this.isAccessible(method)) continue;
                boolean isCompatible = true;
                Class<?>[] v = method.getParameterTypes();
                for (int i = 0; i < v.length; ++i) {
                    if (v[i].isPrimitive() && !v[i].isInstance(Character.TYPE) && !v[i].isInstance(Boolean.TYPE)) {
                        Object object = parameters[i];
                        if (object instanceof Number) {
                            Number num = (Number)object;
                            if (v[i].isAssignableFrom(Integer.TYPE)) {
                                finalParameters[i] = num.intValue();
                                continue;
                            }
                            if (v[i].isAssignableFrom(Float.TYPE)) {
                                finalParameters[i] = Float.valueOf(num.floatValue());
                                continue;
                            }
                            if (v[i].isAssignableFrom(Double.TYPE)) {
                                finalParameters[i] = num.doubleValue();
                                continue;
                            }
                            if (v[i].isAssignableFrom(Long.TYPE)) {
                                finalParameters[i] = num.longValue();
                                continue;
                            }
                            if (v[i].isAssignableFrom(Byte.TYPE)) {
                                finalParameters[i] = num.byteValue();
                                continue;
                            }
                            if (v[i].isAssignableFrom(Short.TYPE)) {
                                finalParameters[i] = num.shortValue();
                                continue;
                            }
                            isCompatible = false;
                            continue;
                        }
                        isCompatible = false;
                        continue;
                    }
                    if (v[i].isAssignableFrom(classes[i])) continue;
                    isCompatible = false;
                }
                if (!isCompatible) continue;
                finalmethod = method;
            }
            if (finalmethod == null) {
                throw new CompileException("No function named \"" + this.getCallSign(classes) + "\" in type \"" + objClass.getSimpleName() + "\"", this.line, this.charpos);
            }
            try {
                return finalmethod.invoke(objValue, finalParameters);
            }
            catch (InvocationTargetException e) {
                if (Hudder.IS_DEBUG) {
                    e.getTargetException().printStackTrace();
                }
                throw new CompileException(e.getTargetException().getMessage(), this.line, this.charpos, e.getTargetException());
            }
            catch (IllegalAccessException e) {
                if (Hudder.IS_DEBUG) {
                    e.printStackTrace();
                }
                throw new CompileException(e.getMessage(), this.line, this.charpos, e);
            }
        }
        try {
            Field f = objClass.getDeclaredField(this.fieldName);
            if (!this.isAccessible(f)) {
                throw new CompileException("No property named \"" + this.fieldName + "\" in type \"" + objClass.getSimpleName() + "\"", this.line, this.charpos);
            }
            return f.get(objValue);
        }
        catch (NoSuchFieldException e) {
            if (objValue instanceof ValueGetter) {
                ValueGetter getter = (ValueGetter)objValue;
                return getter.get(this.fieldName);
            }
            if (Hudder.IS_DEBUG) {
                e.printStackTrace();
            }
            throw new CompileException("No property named \"" + this.fieldName + "\"", this.line, this.charpos);
        }
        catch (ReflectiveOperationException e) {
            if (Hudder.IS_DEBUG) {
                e.printStackTrace();
            }
            throw new CompileException("Failed Reflective Operation property named \"" + this.fieldName + "\"", this.line, this.charpos);
        }
    }

    private String getCallSign(Class<?>[] classes) {
        String res = this.funcName + "(";
        for (int i = 0; i < classes.length; ++i) {
            res = res + classes[i].getSimpleName() + (classes.length == i + 1 ? "" : ", ");
        }
        return res + ")";
    }

    private boolean isAccessible(Field field) {
        return this.isAccessible((Member)field) && !field.isAnnotationPresent(NoAccess.class);
    }

    private boolean isAccessible(Method method) {
        return this.isAccessible((Member)method) && !method.isAnnotationPresent(NoAccess.class);
    }

    private boolean isAccessible(Member method) {
        return method.accessFlags().contains((Object)AccessFlag.PUBLIC) && !method.accessFlags().contains((Object)AccessFlag.PRIVATE);
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        throw new CompileException("Can't change the value of a ClassPropertyCall", this.line, this.charpos);
    }

    @Override
    public boolean isConstant() throws CompileException {
        return false;
    }
}

