/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.main.config;

import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.HudderV2Compiler;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.Compilers;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.utils.HudFileUtils;
import io.github.ngspace.hudder.utils.NoAccess;
import io.github.ngspace.hudder.utils.testing.HudderUnitTester;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minidev.json.JSONObject;

public class HudderConfig {
    public static final int HUDDER_CONFIG_VERSION = 3;
    public static final File DEFAULT_CONFIG_FILE = new File(HudFileUtils.FABRIC_CONFIG_FOLDER + File.separator + "hudder.json");
    @Expose
    public Map<String, Object> globalVariables = new HashMap<String, Object>();
    @Expose
    public String mainfile = "tutorial";
    @Expose
    public boolean enabled = true;
    @Expose
    public boolean shadow = true;
    @Expose
    public boolean showInF3 = false;
    @Expose
    public boolean unsafeoperations = false;
    @Expose
    public boolean globalVariablesEnabled = true;
    @Expose
    public float scale = 1.0f;
    @Expose
    public int color = -2697514;
    @Expose
    public int yoffset = 1;
    @Expose
    public int xoffset = 1;
    @Expose
    public int lineHeight = 10;
    @Expose
    public int methodBuffer = 2;
    @Expose
    public int backgroundcolor = -2043333323;
    @Expose
    public boolean background = true;
    @Expose
    public boolean removegui = false;
    @Expose
    public boolean limitrate = true;
    @Expose
    public int config_version = 3;
    @Expose
    private String compilername = "hudder";
    private ATextCompiler compiler = new HudderV2Compiler();
    private File configFile;
    public HudderUnitTester hudderTester = new HudderUnitTester(new HudderV2Compiler());
    public class_310 mc = class_310.method_1551();

    public HudderConfig(File configFile) {
        File oldconfigloc;
        this.configFile = configFile;
        if (!configFile.exists() && (oldconfigloc = new File(HudFileUtils.FOLDER + "hud.json")).exists()) {
            Hudder.log("Migrating Hudder config");
            if (!oldconfigloc.renameTo(configFile)) {
                Hudder.log("Failed to migrate Hudder config file.");
                throw new UnsupportedOperationException("Failed to migrate Hudder config file.");
            }
        }
        this.readAndUpdateConfig();
    }

    public HudInformation compileMainHud() throws CompileException {
        if (this.getCompiler() != null) {
            return this.getCompiler().compile(this, HudFileUtils.readFile(this.mainfile), this.mainfile);
        }
        throw new CompileException("There is no Compiler!");
    }

    public void readAndUpdateConfig() {
        try {
            if (!this.configFile.exists()) {
                this.save();
                return;
            }
        }
        catch (Exception e) {
            Hudder.IS_DEBUG = true;
            Hudder.log("Failed to create Hudder config file, falling back to default and enabling debug mode.");
            e.printStackTrace();
            return;
        }
        try {
            Hudder.log("Reading Hudder config!");
            String config = HudFileUtils.readFileUnsanitized(this.configFile);
            Hudder.log("Loading Hudder Config File:\n" + config);
            Map newinfo = (Map)new GsonBuilder().create().fromJson(config, HashMap.class);
            if (newinfo.containsKey("debug")) {
                Hudder.IS_DEBUG = (Boolean)newinfo.get("debug");
            }
            if (!newinfo.containsKey("config_version")) {
                this.config_version = 0;
            }
            for (Field f : HudderConfig.class.getDeclaredFields()) {
                if (f.getAnnotation(Expose.class) == null || newinfo.get(f.getName()) == null) continue;
                this.setField(f, newinfo.get(f.getName()));
            }
            if (this.config_version < 3) {
                this.updateConfigFromVersion(this.config_version, newinfo);
                this.config_version = 3;
                this.save();
            }
        }
        catch (IOException e) {
            Hudder.IS_DEBUG = true;
            Hudder.log("Failed to read Hudder config file, enabling debug mode.");
            e.printStackTrace();
        }
        catch (ReflectiveOperationException e) {
            Hudder.IS_DEBUG = true;
            Hudder.log("Failed to set Hudder config values, enabling debug mode.");
            e.printStackTrace();
        }
        this.refreshCompiler();
    }

    private void updateConfigFromVersion(int version, Map<?, ?> newinfo) {
        if (version < 1 && (this.color >> 24 & 0xFF) == 0) {
            this.color = 0xFF000000 | this.color;
        }
        if (version < 2) {
            this.unsafeoperations = (Boolean)newinfo.get("javascript");
        }
        if (version < 3 && newinfo.get("compilertype") != null) {
            this.compilername = switch (newinfo.get("compilertype").toString()) {
                case "none", "null" -> "empty";
                case "javascript" -> "js";
                case "default", "defaultcompiler", "default compiler" -> "hudder";
                default -> newinfo.get("compilertype").toString();
            };
        }
    }

    public void refreshCompiler() {
        try {
            this.compiler = Compilers.getCompilerFromName(this.compilername);
        }
        catch (Exception e) {
            e.printStackTrace();
            Hudder.log("Using default compiler due to error");
            this.compiler = new HudderV2Compiler();
        }
    }

    private void setField(Field f, Object object) throws ReflectiveOperationException {
        if (object instanceof Number) {
            Number num = (Number)object;
            if (f.getType() == Integer.TYPE) {
                f.set(this, num.intValue());
            } else if (f.getType() == Float.TYPE) {
                f.set(this, Float.valueOf(num.floatValue()));
            } else if (f.getType() == Double.TYPE) {
                f.set(this, num.doubleValue());
            } else if (f.getType() == Long.TYPE) {
                f.set(this, num.longValue());
            } else if (f.getType() == Byte.TYPE) {
                f.set(this, num.byteValue());
            } else if (f.getType() == Short.TYPE) {
                f.set(this, num.shortValue());
            } else {
                f.set(this, object);
            }
        } else {
            f.set(this, object);
        }
    }

    public void save() throws IOException {
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            if (!this.configFile.createNewFile()) {
                throw new IOException("Failed to create Hudder config file.");
            }
        }
        try (FileWriter config_writer = new FileWriter(this.configFile);){
            JSONObject json_output = new JSONObject();
            for (Field f : HudderConfig.class.getDeclaredFields()) {
                if (f.getAnnotation(Expose.class) == null) continue;
                json_output.put((Object)f.getName(), f.get(this));
            }
            json_output.put((Object)"debug", (Object)Hudder.IS_DEBUG);
            config_writer.append(new GsonBuilder().setPrettyPrinting().create().toJson((Object)json_output));
            config_writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            Hudder.IS_DEBUG = true;
            throw e;
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            Hudder.IS_DEBUG = true;
        }
    }

    public boolean shouldDrawResult() {
        return !this.mc.field_1690.field_1842 && (!this.mc.field_61504.method_72776() || this.showInF3) && this.enabled;
    }

    public boolean shouldCompile() {
        return this.enabled && this.mc.field_1724 != null;
    }

    public String getCompilerName() {
        return this.compilername;
    }

    public String setCompilerName(String compilername) {
        this.compilername = compilername;
        this.refreshCompiler();
        return compilername;
    }

    public ATextCompiler getCompiler() {
        return this.compiler;
    }

    public static boolean isAccessible(Class<?> clazz) {
        return !clazz.accessFlags().contains((Object)AccessFlag.PRIVATE) && !clazz.isAnnotationPresent(NoAccess.class);
    }

    public static boolean isPublic(Member member) {
        return member.accessFlags().contains((Object)AccessFlag.PUBLIC) && !member.accessFlags().contains((Object)AccessFlag.PRIVATE);
    }
}

