/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.modifiable;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.util.List;

public class V2ArrayRead
extends AV2Value {
    AV2Value indexValue;
    AV2Value array;

    public V2ArrayRead(String value, AV2Compiler compiler, V2Runtime runtime, int line, int charpos, String debugvalue) throws CompileException {
        super(line, charpos, debugvalue, compiler);
        int indexstart = value.lastIndexOf(91);
        String index = value.substring(indexstart + 1, value.length() - 1);
        this.indexValue = compiler.getV2Value(runtime, index, line, charpos);
        this.array = compiler.getV2Value(runtime, value.substring(0, indexstart), line, charpos);
    }

    @Override
    public Object get() throws CompileException {
        Object get = this.array.get();
        if (get instanceof List) {
            List b = (List)get;
            return b.get(this.indexValue.asInt());
        }
        if (get instanceof Object[]) {
            Object[] b = (Object[])get;
            return b[this.indexValue.asInt()];
        }
        throw new CompileException(V2ArrayRead.invalidTypeMessage("Array", this.value, get), this.line, this.charpos);
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        List list = this.array.asType(List.class);
        int index = this.indexValue.asInt();
        if (index == list.size()) {
            list.add(value);
        } else {
            if (index > list.size()) {
                throw new CompileException("You can't set value " + index + " of array before all previous points are set", this.line, this.charpos);
            }
            list.set(index, value);
        }
    }

    @Override
    public boolean isConstant() throws CompileException {
        return false;
    }
}

