package dev.ngspace.ngsmcconfig.api;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import dev.ngspace.ngsmcconfig.options.AbstractNGSMCConfigOption;

public abstract class AbstractNGSMCConfigOptionBuilder<T> {
	
	protected T value;
	protected T defaultValue;
	protected class_2561 name;
	protected Consumer<T> saveOperation;
	protected Function<T, class_2561> validator;

	protected AbstractNGSMCConfigOptionBuilder(T value, class_2561 name) {
		this.value = value;
		this.defaultValue = value;
		this.name = name;
		this.saveOperation = v->{};
	}
	
	public AbstractNGSMCConfigOptionBuilder<T> setValue(T value) {
		this.value = value;
		return this;
	}

	public AbstractNGSMCConfigOptionBuilder<T> setDefaultValue(T defaultValue) {
		this.defaultValue = defaultValue;
		return this;
	}

	public AbstractNGSMCConfigOptionBuilder<T> setName(class_2561 name) {
		this.name = name;
		return this;
	}

	public AbstractNGSMCConfigOptionBuilder<T> setSaveOperation(Consumer<T> saveOperation) {
		this.saveOperation = saveOperation;
		return this;
	}

	public AbstractNGSMCConfigOptionBuilder<T> setHoverComponent(class_5250 hovercomponent) {
		if (name instanceof class_5250 mutablename) {
			mutablename.method_27694(s -> s.method_10949(new class_2568.class_10613(hovercomponent)));
		}
		return this;
	}

	public AbstractNGSMCConfigOptionBuilder<T> setValidator(Function<T, class_2561> validator) {
		this.validator = validator;
		return this;
	}

	public abstract AbstractNGSMCConfigOption<T> build();
}
