package io.github.ngspace.hudder.main;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.main.config.HudderNGSMCConfigMenu;
import io.github.ngspace.hudder.utils.HudFileUtils;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents.StartTick;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HudderTickEvent implements StartTick {
	
    private WatchService watcherService;
    
    public HudderTickEvent() {
		try {
			watcherService = FileSystems.getDefault().newWatchService();
		    Files.walkFileTree(Path.of(HudFileUtils.FOLDER), new SimpleFileVisitor<Path>() {
		        @Override public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs)
		                throws IOException {
		            dir.register(watcherService,
							StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE,
							StandardWatchEventKinds.ENTRY_DELETE);
		            return FileVisitResult.CONTINUE;
		        }

		    });
		} catch (IOException e) {e.printStackTrace();}
	}
    
	@Override public void onStartTick(class_310 client) {
		while (Hudder.configkeybind.method_1436()) {
			class_310.method_1551().method_1507(HudderNGSMCConfigMenu.createMenu(class_310.method_1551().field_1755));
		}
    	if (!Hudder.config.enabled) return;
    	try {
    		if (watcherService==null) return;
    		WatchKey wk = watcherService.poll();
			if (wk!=null) {
				for (WatchEvent<?> event : wk.pollEvents()) {
				    Path changed = (Path) event.context();
				    try {
				    	Hudder.log(changed.getFileName() + " has changed! Refreshing files!");
						HudFileUtils.reloadResources();
						Hudder.showToast(class_2561.method_43470("Refreshed files!").method_27692(class_124.field_1067), 
							class_2561.method_43470("\u00A7a"+changed.getFileName()+" changed."));
					} catch (IOException e) {
						Hudder.showToast(class_2561.method_43470("\\u00A74Error refreshing files!")
								.method_27692(class_124.field_1067),class_2561.method_43470(e.getMessage()));
						e.printStackTrace();
					}
				    if (changed.toString().equals("hud.json")) {
				    	Hudder.config.readConfig();
				    	Hudder.showToast(class_2561.method_43470("Refreshed Config file!").method_27692(class_124.field_1067),
				    			class_2561.method_43470("\u00A7aLoaded File"));
				    }
				}
				if (!wk.reset()) {
					watcherService = null;
					Hudder.error("Unable to watch for changes in config folder!");
					Hudder.showToast(class_2561.method_43470("\u00A74Failed to reload files!").method_27692(class_124.field_1067));
				}
			}
    	} catch (RuntimeException e) {e.printStackTrace();}
	}
}