package io.github.ngspace.hudder.data_management;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3802;
import net.minecraft.class_3871;
import net.minecraft.class_3872;
import net.minecraft.class_3874;
import net.minecraft.class_3934;
import net.minecraft.class_3935;
import net.minecraft.class_3979;
import net.minecraft.class_408;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_466;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_473;
import net.minecraft.class_476;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_486;
import net.minecraft.class_488;
import net.minecraft.class_489;
import net.minecraft.class_491;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.class_495;
import net.minecraft.class_7743;
import net.minecraft.class_8770;
import net.minecraft.class_8898;
import org.lwjgl.glfw.GLFW;

import com.sun.management.OperatingSystemMXBean;

import io.github.ngspace.hudder.data_management.api.DataVariableRegistry;
import io.github.ngspace.hudder.data_management.api.VariableTypes;
import io.github.ngspace.hudder.v2runtime.V2Runtime;

public class Advanced {private Advanced() {}

	public static int fps = 0;
	public static List<Long> clicks_left = new ArrayList<Long>();
	public static List<Long> cps_right = new ArrayList<Long>();

	public static double gpuUsage = 0;
	public static float delta = 1;
	public static LimitedRefreshSpeedData<Double> CPU = new LimitedRefreshSpeedData<Double>(
			((OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean())::getProcessCpuLoad, 2000);
	
	public static String OS = getOS();

	static String getOS() {
		String OS = System.getProperty("os.name", "generic").toLowerCase();
		if ((OS.contains("mac")) || (OS.contains("darwin"))) OS = "mac";
		else if (OS.contains("nux")) OS = "linux";
		else if (OS.contains("win")) OS = "windows";
		else OS = "other";
		return OS;
	}

	static double oldcps_l = 0;
	static double newcps_l = 0;
	static double oldcps_r = 0;
	static double newcps_r = 0;
	
    public static void updateCPS() {
        long now = System.currentTimeMillis();
        clicks_left.removeIf(age -> age < now - 1000);
        oldcps_l = newcps_l;
        newcps_l = clicks_left.size();
        cps_right.removeIf(age -> age < now - 1000);
        oldcps_r = newcps_r;
        newcps_r = cps_right.size();
    }
    
    public static double getLeftCPS() {
    	return truncate(oldcps_l*.8 + newcps_l*.2, 3);
    }
    
    public static double getRightCPS() {
    	return truncate(oldcps_r*.8 + newcps_r*.2, 3);
    }
	
	
	
	/* FPS */
	
	
	
    private static final List<Integer> fpshistory = new ArrayList<Integer>();

    public static int getFPS(class_310 ins) {
    	int fps = ins.method_47599();
        fpshistory.add(fps);
        if (fpshistory.size()>200) fpshistory.remove(0);
        return fps;
    }
    public static int getMinimumFPS() {int max = fpshistory.get(0);for (int i:fpshistory) if (i<max) max=i;return max;}
    public static int getMaximumFPS() {int max = 0;for (int i:fpshistory) if (i>max) max=i;return max;}
    public static int getAverageFPS() {int sum = 0;for (int fps : fpshistory) sum+=fps;return sum/fpshistory.size();}
    
    
    
    /* Keyboard */
    
    
    
    public static final Map<Integer,Integer> held_keys = new HashMap<Integer,Integer>();
	
	public static void registerKeyVariables() {
		ArrayList<String> keyNames = new ArrayList<String>();
		HashMap<String, Integer> keys = new HashMap<String, Integer>();
		
	    for (Field field : GLFW.class.getFields()) {
	    	try {
	    		if (field.getName().startsWith("GLFW_KEY_")&&field.canAccess(null)) {
	    			String keyname = field.getName().substring(9).toLowerCase();
	    			keyNames.add("key_" + keyname);
	    			keys.put(keyname,field.getInt(null));
	    		}
			} catch (Exception e) {e.printStackTrace();}
	    }
	    
	    DataVariableRegistry.registerVariable(
	    		variable->held_keys.containsKey(keys.get(variable.substring(4).toLowerCase())),
	    		VariableTypes.BOOLEAN, keyNames.toArray(new String[keyNames.size()]));
	}
	
	
	public static Object getScreenType(class_437 screen) {
		return switch (screen) {
			case class_3871 scr: yield "Blast Furnace";
			case class_3874 scr: yield "Smoker";
			case class_489<?> scr: yield "Furnace";
			case class_7743 scr: yield "Sign Edit";
			case class_471 scr: yield "Anvil";
			case class_466 scr: yield "Beacon";
			case class_473 scr: yield "Book Edit";
			case class_472 scr: yield "Brewing Stand";
			case class_3934 scr: yield "Cartography Table";
			case class_8898 scr: yield "Crafter";
			case class_479 scr: yield "Crafting";
			case class_481 scr: yield "Creative Mode Inventory";
			case class_486 scr: yield "Enchantment";
			case class_476 scr: yield "Container";
			case class_3802 scr: yield "Grindstone";
			case class_488 scr: yield "Hopper";
			case class_491 scr: yield "Horse Inventory";
			case class_3935 scr: yield "Lectern";
			case class_494 scr: yield "Loom";
			case class_492 scr: yield "Merchant";
			case class_8770 scr: yield "Report Player";
			case class_495 scr: yield "Shulker Box";
			case class_3979 scr: yield "Stonecutter";
			case class_433 scr: yield "Pause";
			case class_408 scr: yield "Chat";
			case class_3872 scr: yield "Anvil";
			case class_465<?> scr: yield "Generic container";
			
			
			case null:
				yield V2Runtime.NULL;
			default:
				yield screen.getClass().getSimpleName();
		};
	}
	
	static double truncate(double num, int cutoff) {
		return Math.floor(num*Math.pow(10, cutoff))/Math.pow(10, cutoff);
	}
}