package io.github.ngspace.hudder.data_management;

import java.util.Calendar;
import java.util.Locale;
import net.minecraft.class_1496;
import net.minecraft.class_155;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import com.mojang.blaze3d.platform.GLX;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.data_management.api.DataVariableRegistry;
import io.github.ngspace.hudder.v2runtime.V2Runtime;

public class StringData {private StringData() {}
	@SuppressWarnings("deprecation")
	public static Object getString(String key) {
		class_310 ins = class_310.method_1551();
		class_746 p = ins.field_1724;
		class_4184 c = ins.field_1773.method_19418();
		return switch (key) {
			
			case "damagetype": yield p.method_6081() == null ? V2Runtime.NULL : p.method_6081().method_48792().toString();
			
			/* Computer info */
			case "cpu_info": yield GLX._getCpuInfo();
			case "operating_system": yield Advanced.OS;
			case "month_name": yield Calendar.getInstance().getDisplayName(Calendar.MONTH,Calendar.LONG,Locale.getDefault());
			case "locale": yield Locale.getDefault().getDisplayName();
			case "language": yield Locale.getDefault().getLanguage();
			case "country": yield Locale.getDefault().getCountry();


			/* Game */
			case "version_type": yield ins.method_1547();
			case "game_version": yield class_155.method_16673().comp_4024();



			/* Player */
			case "username": yield ins.field_1724.method_5477().getString();
			case "uuid": yield ins.field_1724.method_5845();
			


			/* Inventory */
			case "helditem_name": yield ins.field_1724.method_31548()
				.method_5438(ins.field_1724.method_31548().method_67532()).method_7954().getString();
			
			
			
			/* GUI */
			case "openguitype": yield Advanced.getScreenType(ins.field_1755);
			case "openguititle": yield ins.field_1755 == null ? V2Runtime.NULL : ins.field_1755.method_25440().getString();



			/* Mount information */
			case "mount_type": yield p.method_5854() == null ? V2Runtime.NULL : p.method_5854().method_5864().method_40124().method_40237().method_29177().toString();
			case "mount_armor_type": yield (p.method_5854() instanceof class_1496 horse) ? horse.method_56676().method_7909().toString() : V2Runtime.NULL;
			case "mount_name": yield p.method_5854() == null || p.method_5854().method_5797() == null ? V2Runtime.NULL : p.method_5854().method_5797().getString();



			/* World */
			case "biome":
				yield ins.field_1687.method_23753(ins.field_1724.method_24515()).method_55840();
			case "cam_biome":
				yield ins.field_1687.method_23753(c.method_19328()).method_55840();
			case "dimension":
				yield ins.field_1687.method_27983().toString();
			case "world_name":
				yield ins.method_1576() == null ? V2Runtime.NULL : ins.method_1576().method_27728().method_150();



			/* Server */
			case "server_name":
				yield ins.method_1558() == null ? V2Runtime.NULL : ins.method_1558().field_3752;
			case "server_ip":
				yield ins.method_1558() == null ? V2Runtime.NULL : ins.method_1558().field_3761;
			case "server_motd":
				yield ins.method_1558() == null ? V2Runtime.NULL : ins.method_1558().field_3757.getString();


			
			/* Looking at */
			case "looking_at_pos": {
				class_3965 hit = raycast(ins, p.method_5836(1.0f), p.method_5720(), 50, false);
				yield (hit == null) ? V2Runtime.NULL : hit.method_17777().method_10263() + " " + hit.method_17777().method_10264() + " " + hit.method_17777().method_10260();
			}

			case "cam_looking_at_pos": {
				class_243 camPos = c.method_71156();
				class_243 camLook = new class_243(c.method_19335().x(), c.method_19335().y(), c.method_19335().z());
				class_3965 hit = raycast(ins, camPos, camLook, 50, false);
				yield (hit == null) ? V2Runtime.NULL : hit.method_17777().method_10263() + " " + hit.method_17777().method_10264() + " " + hit.method_17777().method_10260();
			}

			case "block_in_front": {
				class_3965 hit = raycast(ins, p.method_5836(1.0f), p.method_5720(), 50, false);
				yield (hit == null) ? V2Runtime.NULL : class_7923.field_41175.method_10221(ins.field_1687.method_8320(hit.method_17777()).method_26204()).toString();
			}

			case "cam_block_in_front": {
				class_243 camPos = c.method_71156();
				class_243 camLook = new class_243(c.method_19335().x(), c.method_19335().y(), c.method_19335().z());
				class_3965 hit = raycast(ins, camPos, camLook, 50, false);
				yield (hit == null) ? V2Runtime.NULL : class_7923.field_41175.method_10221(ins.field_1687.method_8320(hit.method_17777()).method_26204()).toString();
			}

			case "fluid_in_front": {
				class_3965 hit = raycast(ins, p.method_5836(1.0f), p.method_5720(), 50, true);
				yield (hit == null) ? V2Runtime.NULL : class_7923.field_41173.method_10221(ins.field_1687.method_8316(hit.method_17777()).method_15772()).toString();
			}

			case "cam_fluid_in_front": {
				class_243 camPos = c.method_71156();
				class_243 camLook = new class_243(c.method_19335().x(), c.method_19335().y(), c.method_19335().z());
				class_3965 hit = raycast(ins, camPos, camLook, 50, true);
				yield (hit == null) ? V2Runtime.NULL : class_7923.field_41173.method_10221(ins.field_1687.method_8316(hit.method_17777()).method_15772()).toString();
			}

			case "entity_in_front":
				yield (ins.field_1692 == null) ? V2Runtime.NULL : class_7923.field_41177.method_10221(ins.field_1692.method_5864()).toString();



			/* Hudder */
			case "compilertype": yield Hudder.config.getCompilerName();
			case "mainfile": yield Hudder.config.mainfile;
			
			case "unset": yield "unset";
			
			default: yield DataVariableRegistry.getString(key);
		};
	}
	private static class_3965 raycast(class_310 ins, class_243 start, class_243 direction, double reach, boolean fluid) {
		class_3959.class_242 fluidMode = fluid ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348;
		class_243 end = start.method_1019(direction.method_1021(reach));

		class_239 hit = ins.field_1687.method_17742(new class_3959(
				start,
				end,
				class_3959.class_3960.field_17559,
				fluidMode,
				ins.field_1724
		));

		return (hit.method_17783() == class_239.class_240.field_1332) ? (class_3965) hit : null;
	}
}
