package io.github.ngspace.hudder.main;

import java.util.List;

import org.joml.Matrix3x2fStack;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.uielements.AUIElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9779;
import net.minecraft.class_9848;

/**
 * Hudder.java was too messy so I moved all rendering functions into this one class
 */
public class HudderRenderer implements HudElement {
	
	private HudCompilationManager compman;
	public class_2960 hudElementRegistryID = class_2960.method_60655("hudder_renderer", "renderer");
	protected static class_310 mc = class_310.method_1551();
    public static final String NL_REGEX = "\r?\n";
	
	
	
	public final RenderPipeline GUI_TEXTURED_TRIANGLES = class_10799.method_67887(RenderPipeline.builder(
			class_10799.field_56864).withLocation("pipeline/gui_textured_triangles")
			.withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27380).build());
	
	
	
	public HudderRenderer(HudCompilationManager compilationManager) {
		this.compman = compilationManager;
	}
	
	
	
	protected void renderFail(class_332 context, String FailMessage) {
		List<class_5481> lines = mc.field_1772.method_1728(class_5348.method_29430(FailMessage),
			mc.method_22683().method_4486()-10);
		int y = 1;
		for (class_5481 line : lines) {
        	context.method_51430(mc.field_1772, line, 1, y, 0xFFFF5555, true);
			y+=9;
		}
	}
	
	
	
	protected void renderHudInformation(class_332 context, class_327 renderer, HudInformation text, HudderConfig info,
			class_9779 delta) {
        int color = info.color;
        int bgcolor = info.backgroundcolor;
        boolean shadow = info.shadow;
        boolean background = info.background;
        
        /* Top Left */
        String[] lines = text.TopLeftText.split(NL_REGEX);
        int yoff = info.yoffset;
        int xoff = info.xoffset;
        for (String txt : lines) {
        	renderTextLine(context, txt, xoff, yoff, color, text.TLScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.TLScale;
        }
        
        /* Bottom Left */
        String[] BL = text.BottomLeftText.split(NL_REGEX);
        yoff = (int) (context.method_51443() - countLines(text.BottomLeftText) *
        		info.lineHeight * text.BLScale - info.yoffset + 1);
        xoff = info.xoffset;
        for (String txt : BL) {
        	renderTextLine(context, txt, xoff, yoff, color, text.BLScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.BLScale;
        }
        
        /* Top Right */
        String[] TR = text.TopRightText.split(NL_REGEX);
        yoff = info.yoffset;
        for (String txt : TR) {
        	xoff = (int) (context.method_51421() - renderer.method_1727(txt) * text.TRScale - info.xoffset);
        	renderTextLine(context, txt, xoff, yoff, color, text.TRScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.TRScale;
        }
        
        /* Bottom Right */
        String[] BR = text.BottomRightText.split(NL_REGEX);
        yoff = (int) (context.method_51443() - countLines(text.BottomRightText) *
        		info.lineHeight * text.BRScale - info.yoffset + 1);
        for (String txt : BR) {
        	xoff = (int) (context.method_51421() - renderer.method_1727(txt) * text.BRScale - info.xoffset);
        	renderTextLine(context, txt, xoff, yoff, color, text.BRScale, shadow, background, bgcolor);
        	yoff+=info.lineHeight * text.BRScale;
        }
        
        for (AUIElement e : text.elements) e.renderElement(context, this, delta);
    }
	
	
	
    private int countLines(String str) {
        int count = 1;
        for (int i = 0; i<str.length();i++) if (str.charAt(i) == '\n') count++;
        return count;
    }
    
    

	public void renderTextLine(class_332 context, String text, int x, int y, int color, float scale, boolean shadow,
			boolean background, int backgroundColor) {
        if (scale != 1.0f) {
            Matrix3x2fStack matrixStack = context.method_51448();
            matrixStack.pushMatrix();
            matrixStack.translate(x, y);
            matrixStack.scale(scale, scale);
            matrixStack.translate(-x, -y);
    		if (background&&!"".equals(text))
    			renderBlock(context,x-1,y-1,mc.field_1772.method_1727(text)+2,10,backgroundColor);
            context.method_51433(mc.field_1772, text, x, y, color, shadow);
            matrixStack.popMatrix();
        } else {
    		if (background&&!"".equals(text))
    			renderBlock(context,x-1,y-1,mc.field_1772.method_1727(text)+2,10,backgroundColor);
        	context.method_51433(mc.field_1772, text, x, y, color, shadow);
        }
    }
	
	
	
	public void renderBlock(class_332 graphics, int x, int y, int width, int height, int argb) {
		graphics.method_25294(x, y, x+width, y+height, argb);
	}
	
	
	
	public void renderTexture9Slice(class_332 context, class_2960 id, float x, float y, float width,
			float height, float[] slices) {
		var tex = mc.method_1531().method_4619(id);
		context.field_59826.method_70919(new TextureRenderState(class_11231.method_70900(tex.method_71659(),
				tex.method_75484()), class_10799.field_56883, vconsumer->{
		    Matrix3x2fStack matrix = context.method_51448();
	        class_1011 img = ((class_1043)mc.method_1531().method_4619(id)).method_4525();
	        int texwidth = img.method_4307();
	        int texheight = img.method_4323();

	        float left = Math.min(slices[0],texwidth/2f);
	        float right = Math.min(slices[1],texwidth/2f);
	        float top = Math.min(slices[2],texheight/2f);
	        float bottom = Math.min(slices[3],texheight/2f);
	        
	        float middlestart_hor = x+left;
	        float middleend_hor = x+width-right;
	        float middleend_tex_hor = (texwidth-right)/texwidth;
	        float tls = left/texwidth;
	        
	        
	        float middlestart_ver = y+top;
	        float middleend_ver = y + height - bottom;
	        float middleend_tex_ver = (texheight-bottom)/texheight;
	        float lts = top/texheight;
	        
	        // Top-left
	        vconsumer.method_70815(matrix,x,y).method_22913(0,0).method_39415(-1);
	        vconsumer.method_70815(matrix,x,y+top).method_22913(0,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,y+top).method_22913(tls,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,y).method_22913(tls,0).method_39415(-1);
	        
	        // Top-middle
	        vconsumer.method_70815(matrix,middlestart_hor,y).method_22913(tls, 0).method_39415(-1);
	        vconsumer.method_70815(matrix,middlestart_hor,y+top).method_22913(tls,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,y+top).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,y).method_22913(middleend_tex_hor,0).method_39415(-1);
	        
	        // Top-right
	        vconsumer.method_70815(matrix,middleend_hor,y).method_22913(middleend_tex_hor,0).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,y+top).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,y+top).method_22913(1,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,y).method_22913(1,0).method_39415(-1);
	        
	        
	        
	        // Middle-left
	        vconsumer.method_70815(matrix,x,middlestart_ver).method_22913(0,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,x,middleend_ver).method_22913(0,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,middleend_ver).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,middlestart_ver).method_22913(tls,lts).method_39415(-1);
	        
	        // Middle-middle
	        vconsumer.method_70815(matrix,middlestart_hor,middlestart_ver).method_22913(tls, lts).method_39415(-1);
	        vconsumer.method_70815(matrix,middlestart_hor,middleend_ver).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,middleend_ver).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,middlestart_ver).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        
	        // Middle-right
	        vconsumer.method_70815(matrix,middleend_hor,middlestart_ver).method_22913(middleend_tex_hor,lts).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,middleend_ver).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,middleend_ver).method_22913(1,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,middlestart_ver).method_22913(1,lts).method_39415(-1);
	        
	        
	        
	        // Bottom-left
	        vconsumer.method_70815(matrix,x,middleend_ver).method_22913(0,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,x,y+height).method_22913(0,1).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,y+height).method_22913(tls,1).method_39415(-1);
	        vconsumer.method_70815(matrix,x+left,middleend_ver).method_22913(tls,middleend_tex_ver).method_39415(-1);
	        
	        // Bottom-middle
	        vconsumer.method_70815(matrix,middlestart_hor,middleend_ver).method_22913(tls, middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,middlestart_hor,y+height).method_22913(tls,1).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,y+height).method_22913(middleend_tex_hor,1).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,middleend_ver).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        
	        // Bottom-right
	        vconsumer.method_70815(matrix,middleend_hor,middleend_ver).method_22913(middleend_tex_hor,middleend_tex_ver).method_39415(-1);
	        vconsumer.method_70815(matrix,middleend_hor,y+height).method_22913(middleend_tex_hor,1).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,y+height).method_22913(1,1).method_39415(-1);
	        vconsumer.method_70815(matrix,x+width,middleend_ver).method_22913(1,middleend_tex_ver).method_39415(-1);
		}));
	}

	public void renderTexturedVertexArray(class_332 context, float[] vertices, float[] textures,
			class_2960 id, boolean triangles) {
		var tex = mc.method_1531().method_4619(id);
		context.field_59826.method_70919(new TextureRenderState(class_11231.method_70900(tex.method_71659(),
				tex.method_75484()),
				triangles ? GUI_TEXTURED_TRIANGLES : class_10799.field_56883, vconsumer->{
		        Matrix3x2fStack matrix = context.method_51448();
		        
	        for (int i = 0;i<vertices.length;i+=2) {
	        	vconsumer.method_70815(matrix,vertices[i],vertices[i+1]).method_22913(textures[i],textures[i+1]).method_39415(-1);
	        }
		}));
	}
	
	
	
	/**
	 * Draws the provided vertices on screen with the provided color and render mode
	 * 
	 * @deprecated Use {@link #renderColoredVertexArray(class_332, float[], int, boolean)} instead.
	 * If needed, use {@link class_9848#method_61324(int, int, int, int)}.
	 * 
	 * @param context The render context
	 * @param vertices The array holding all the vertices
	 * @param r red
	 * @param g green
	 * @param b blue
	 * @param a alpha
	 * @param mode The rendering mode
	 */
	@Deprecated(since = "TBD", forRemoval = false)
	public void renderColoredVertexArray(class_332 context, float[] vertices, int r, int g, int b, int a,
			boolean triangle_strip) {
		renderColoredVertexArray(context, vertices, class_9848.method_61324(r, g, b, a), triangle_strip);
	}
	
	
	
	/**
	 * Draws the provided vertices on screen with the provided color and render mode
	 * @param context The render context
	 * @param vertices The array holding all the vertices
	 * @param argb The ARGB color value
	 * @param mode The rendering mode
	 */
	public void renderColoredVertexArray(class_332 context, float[] vertices, int argb, boolean triangle_strip) {
		context.field_59826.method_70919(new TextureRenderState(class_11231.method_70899(),
			triangle_strip ? GUI_TEXTURED_TRIANGLES : class_10799.field_56883, vconsumer -> {
			
	        Matrix3x2fStack matrix = context.method_51448();
	        
	        for (int i = 0;i<vertices.length;i+=2)
	        	vconsumer.method_70815(matrix,vertices[i],vertices[i+1]).method_39415(argb).method_22913(0, 0);
		}));
	}
	
	
	
	@Override public void render(class_332 context, class_9779 delta) {
		try {
			if (!Hudder.config.limitrate) compman.compile(delta);
			if (Hudder.config.shouldDrawResult()) {
	            try {
	            	if (compman.getResult()!=null)
	            		renderHudInformation(context, mc.field_1772, compman.getResult(), Hudder.config, delta);
	            	else
	            		renderFail(context, HudCompilationManager.LastFailMessage);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
    	} catch (RuntimeException e) {
			e.printStackTrace();
		}
		
	}
}
