/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder;

import io.github.ngspace.hudder.api.functionsandconsumers.HudderBuiltInFunctions;
import io.github.ngspace.hudder.api.functionsandconsumers.HudderBuiltInMethods;
import io.github.ngspace.hudder.compilers.utils.Compilers;
import io.github.ngspace.hudder.compilers.utils.functionandconsumerapi.FunctionAndConsumerAPI;
import io.github.ngspace.hudder.data_management.Advanced;
import io.github.ngspace.hudder.data_management.EffectData;
import io.github.ngspace.hudder.data_management.ResourcePackVariables;
import io.github.ngspace.hudder.data_management.api.DataVariableRegistry;
import io.github.ngspace.hudder.main.HudCompilationManager;
import io.github.ngspace.hudder.main.HudderRenderer;
import io.github.ngspace.hudder.main.HudderTickEvent;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.HudFileUtils;
import io.github.ngspace.hudder.utils.testing.HudderUnitTestingCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Scanner;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2983;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hudder
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"hudder");
    public static String HUDDER_VERSION = "${version}";
    public static boolean IS_DEBUG = false;
    public static HudderConfig config;
    public static class_304 configkeybind;

    public void onInitializeClient() {
        File gradleProp;
        Hudder.log("Starting Hudder " + HUDDER_VERSION);
        configkeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("hudder.configkeybind", class_3675.class_307.field_1668, 82, class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"hudder.keybinds"))));
        Optional containerOpt = FabricLoader.getInstance().getModContainer("hudder");
        if (containerOpt.isPresent()) {
            HUDDER_VERSION = ((ModContainer)containerOpt.get()).getMetadata().getVersion().getFriendlyString();
        }
        if (HUDDER_VERSION.equals("${version}") && (gradleProp = new File("../gradle.properties")).exists()) {
            try (Scanner scanner = new Scanner(gradleProp);){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    if (!line.startsWith("mod_version=")) continue;
                    HUDDER_VERSION = line.substring(12);
                }
            }
            catch (FileNotFoundException e) {
                Hudder.log("Can not determine Hudder version!");
                e.printStackTrace();
            }
        }
        Hudder.log("Loading default compilers");
        Compilers.registerDefaultCompilers();
        Hudder.log("Reading Hudder config");
        config = new HudderConfig(HudderConfig.DEFAULT_CONFIG_FILE);
        if (IS_DEBUG) {
            Hudder.log("HUDDER'S DEBUG MODE IS TURNED ON");
            Hudder.log(System.err.getClass().getCanonicalName());
            System.setErr((PrintStream)new class_2983(this, "STDERR", System.err){
                private static final Logger wk = LoggerFactory.getLogger((String)"Minecraft");

                protected void method_12870(@Nullable String string) {
                    wk.error("[{}]: {}", (Object)this.field_13383, (Object)string);
                }
            });
        }
        ClientCommandRegistrationCallback.EVENT.register((Object)new HudderUnitTestingCommand());
        HudFileUtils.makeDefaultHud();
        HudderBuiltInMethods.registerMethods(FunctionAndConsumerAPI.getInstance());
        HudderBuiltInFunctions.registerFunction(FunctionAndConsumerAPI.getInstance());
        ClientTickEvents.START_CLIENT_TICK.register((Object)new HudderTickEvent());
        DataVariableRegistry.registerVariable(new ResourcePackVariables(), "selectedresourcepacks", "selectedresourcepacks_unfiltered");
        DataVariableRegistry.registerVariable(new EffectData(), "active_effects");
        Advanced.registerKeyVariables();
        HudCompilationManager compman = new HudCompilationManager();
        ClientTickEvents.END_CLIENT_TICK.register((Object)compman);
        HudderRenderer renderer = new HudderRenderer(compman);
        HudElementRegistry.addLast((class_2960)renderer.hudElementRegistryID, (HudElement)renderer);
        ClientLifecycleEvents.CLIENT_STARTED.register(c -> {
            try {
                HudFileUtils.reloadResources();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        class_310 mc = class_310.method_1551();
        HudCompilationManager.addPreCompilerListener(c -> {
            Advanced.fps = Advanced.getFPS(mc);
        });
        Hudder.log("Hudder has finished loading!");
    }

    public static void showToast(class_2561 title, class_2561 content) {
        class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, title, content));
    }

    public static void showWarningToast(class_2561 title, class_2561 content) {
        class_310.method_1551().method_1566().method_1999((class_368)new class_370(new class_370.class_9037(10000L), title, content));
    }

    public static void log(Object str) {
        LOGGER.info(String.valueOf(str));
    }

    public static void warn(Object str) {
        LOGGER.warn(String.valueOf(str));
    }

    public static void error(Object str) {
        LOGGER.error(String.valueOf(str));
    }

    public static void debug(Object str) {
        LOGGER.debug(String.valueOf(str));
    }

    public static void alert(Object str) {
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43472((String)String.valueOf(str)), false);
    }
}

