/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.abstractions;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.AVarTextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.compilers.utils.IScriptingLanguageEngine;
import io.github.ngspace.hudder.compilers.utils.functionandconsumerapi.ArrayElementManager;
import io.github.ngspace.hudder.data_management.BooleanData;
import io.github.ngspace.hudder.data_management.NumberData;
import io.github.ngspace.hudder.data_management.ObjectDataAPI;
import io.github.ngspace.hudder.data_management.StringData;
import io.github.ngspace.hudder.main.HudCompilationManager;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.uielements.AUIElement;
import io.github.ngspace.hudder.uielements.ItemElement;
import io.github.ngspace.hudder.utils.HudFileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public abstract class AScriptingLanguageCompiler
extends AVarTextCompiler {
    protected static class_310 mc = class_310.method_1551();
    public Map<String, RuntimeCache> cache = new HashMap<String, RuntimeCache>();
    public ArrayElementManager elms = new ArrayElementManager();

    protected AScriptingLanguageCompiler() {
        HudCompilationManager.addPreCompilerListener(c -> {
            if (c == this) {
                this.elms.clear();
            }
        });
        HudFileUtils.addReloadResourcesListener(() -> {
            for (RuntimeCache c : this.cache.values()) {
                c.close();
            }
            this.cache.clear();
        });
    }

    protected abstract IScriptingLanguageEngine createLangEngine() throws CompileException;

    @Override
    public HudInformation compile(HudderConfig info, String text, String filename) throws CompileException {
        if (AScriptingLanguageCompiler.mc.field_1724 == null) {
            return HudInformation.of("");
        }
        RuntimeCache rtcache = this.cache.get(text);
        IScriptingLanguageEngine wrapper = null;
        try {
            if (rtcache != null && rtcache.exception != null) {
                throw rtcache.exception;
            }
            IScriptingLanguageEngine iScriptingLanguageEngine = wrapper = rtcache == null ? null : rtcache.engine;
            if (wrapper == null) {
                wrapper = this.createLangEngine();
                this.loadFunctions(wrapper);
                Exception exception = null;
                try {
                    wrapper.evaluateCode(text, filename);
                }
                catch (Exception e) {
                    exception = e;
                    wrapper.close();
                }
                this.cache.put(text, new RuntimeCache(wrapper, exception));
            }
            String TL = String.valueOf(wrapper.callFunctionSafe("topleft", "", new String[0]));
            String BL = String.valueOf(wrapper.callFunctionSafe("bottomleft", "", new String[0]));
            String TR = String.valueOf(wrapper.callFunctionSafe("topright", "", new String[0]));
            String BR = String.valueOf(wrapper.callFunctionSafe("bottomright", "", new String[0]));
            wrapper.callFunctionSafe("createElements", null, new String[0]);
            float TLscale = wrapper.readVariableSafe("topleftscale", Float.valueOf(1.0f)).asFloat();
            float BLscale = wrapper.readVariableSafe("bottomleftscale", Float.valueOf(1.0f)).asFloat();
            float TRscale = wrapper.readVariableSafe("toprightscale", Float.valueOf(1.0f)).asFloat();
            float BRscale = wrapper.readVariableSafe("bottomrightscale", Float.valueOf(1.0f)).asFloat();
            return new HudInformation(TL, TLscale, BL, BLscale, TR, TRscale, BR, BRscale, this.elms.toArray(new AUIElement[this.elms.size()]));
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            if (Hudder.IS_DEBUG) {
                e.printStackTrace();
            }
            if (wrapper != null) {
                throw wrapper.processException(e);
            }
            if (e instanceof RuntimeException) {
                RuntimeException ex = (RuntimeException)e;
                throw ex;
            }
            throw new CompileException(e.getMessage(), -1, -1, e);
        }
    }

    @Override
    public Object getVariable(String key) throws CompileException {
        Object obj = NumberData.getNumber(key);
        if (obj != null) {
            return obj;
        }
        obj = StringData.getString(key);
        if (obj != null) {
            return obj;
        }
        obj = BooleanData.getBoolean(key);
        if (obj != null) {
            return obj;
        }
        obj = ObjectDataAPI.getObject(key);
        if (obj != null) {
            return obj;
        }
        obj = this.get(key);
        if (obj != null) {
            return obj;
        }
        obj = Hudder.config.globalVariables.get(key);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public void loadFunctions(IScriptingLanguageEngine engine) {
        engine.bindConsumer(s -> this.elms.add(new ItemElement(s[1].asInt(), s[2].asInt(), new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_12829((String)s[0].asString()))), s[3].asFloat(), false)), "drawItem", "item");
        engine.bindConsumer(s -> this.elms.add(new ItemElement(s[1].asInt(), s[2].asInt(), AScriptingLanguageCompiler.mc.field_1724.method_31548().method_5438(s[0].asInt()), s[3].asFloat(), s[4].asBoolean())), "drawSlot", "slot");
        engine.bindConsumer(s -> this.elms.add(new ItemElement(s[1].asInt(), s[2].asInt(), AScriptingLanguageCompiler.mc.field_1724.method_31548().method_5438(36 + s[0].asInt()), s[3].asFloat(), s[4].asBoolean())), "drawArmor", "armor");
    }

    public static class RuntimeCache
    implements Closeable {
        public IScriptingLanguageEngine engine;
        public Exception exception;

        public RuntimeCache(IScriptingLanguageEngine engine, Exception exception) {
            this.engine = engine;
            this.exception = exception;
        }

        @Override
        public void close() throws IOException {
            this.exception = null;
            this.engine.close();
        }
    }
}

