/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.runtime_elements;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.abstractions.AVarTextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.uielements.AUIElement;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.runtime_elements.AV2RuntimeElement;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.util.Arrays;

public class ConditionV2RuntimeElement
extends AV2RuntimeElement {
    AV2Value[] results = new AV2Value[0];
    AV2Value[] conditions = new AV2Value[0];
    AVarTextCompiler compiler;
    HudderConfig info;
    boolean hasElse;
    private String filename;

    public ConditionV2RuntimeElement(String[] condArgs, AV2Compiler compiler, HudderConfig info, V2Runtime runtime, int line, int charpos, String filename) throws CompileException {
        this.compiler = compiler;
        this.info = info;
        this.filename = filename;
        this.hasElse = condArgs.length % 2 == 1;
        for (int i = 0; i < condArgs.length; ++i) {
            String str = condArgs[i];
            if (this.hasElse && i == condArgs.length - 1) {
                this.results = ConditionV2RuntimeElement.addToArray(this.results, compiler.getV2Value(runtime, str, line, charpos));
                break;
            }
            if (i % 2 == 0) {
                this.conditions = ConditionV2RuntimeElement.addToArray(this.conditions, compiler.getV2Value(runtime, str, line, charpos));
                continue;
            }
            this.results = ConditionV2RuntimeElement.addToArray(this.results, compiler.getV2Value(runtime, str, line, charpos));
        }
    }

    @Override
    public boolean execute(CompileState meta, StringBuilder builder) throws CompileException {
        HudInformation res = null;
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].asBoolean()) continue;
            res = this.compiler.compile(this.info, this.results[i].asString(), this.filename);
            break;
        }
        if (res == null && this.hasElse) {
            res = this.compiler.compile(this.info, this.results[this.results.length - 1].asString(), this.filename);
        }
        if (res != null) {
            builder.append(res.TopLeftText);
            for (AUIElement v : res.elements) {
                meta.elements.add(v);
            }
        }
        return true;
    }

    private static <T> T[] addToArray(T[] arr, T t) {
        T[] newarr = Arrays.copyOf(arr, arr.length + 1);
        newarr[arr.length] = t;
        return newarr;
    }
}

