package dev.ngspace.ngsmcconfig.options;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import dev.ngspace.ngsmcconfig.gui.NGSMCConfigEntry;

public abstract class AbstractTextFieldNGSMCConfigOption<T> extends AbstractNGSMCConfigOption<T> {

	protected Predicate<String> textfilter = e->true;
	int max_length = Integer.MAX_VALUE;
	class_342 widget;

	protected AbstractTextFieldNGSMCConfigOption(T defaultValue, T value, class_2561 text, Consumer<T> saveOperation,
			Function<T, class_2561> validator) {
		super(defaultValue, value, text, saveOperation, validator);
	}

	@Override
	public NGSMCConfigEntry buildEntry() {
		widget = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 20, class_2561.method_43470(""));
		widget.method_1880(max_length);
		widget.method_1852(stringify());
		widget.method_1890(e->{
			edited = true;
			return textfilter.test(e);
		});
		return new NGSMCConfigEntry(widget, text, this);
	}
	
	protected String stringify() {
		return String.valueOf(value);
	}

	@Override
	public void reset() {
		edited = true;
		value = defaultValue;
    	if (widget!=null)
    		widget.method_1852(stringify());
	}
}
