package io.github.ngspace.hudder.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map.Entry;
import java.util.Scanner;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CachedReader {
	
	protected static class_310 mc = class_310.method_1551();
	
	public Reader reader = new FilesRABReader();
	

	HashMap<String, byte[]> savedFiles = new HashMap<String, byte[]>();
	HashMap<String, String> savedFilesStrings = new HashMap<String, String>();
	HashMap<class_2960, class_1043> savedImages = new HashMap<class_2960, class_1043>();
	
	

	public byte[] getCachedFile(String file) {return savedFiles.get(file);}
	public String getCachedFileAsString(String file) {
		String contents = savedFilesStrings.get(file);
		if (contents == null) {
			contents = new String(getCachedFile(file));
			savedFilesStrings.put(file, contents);
			return contents;
		}
		return contents;
	}
	
	
	
	public boolean loadFileToCache(File file) throws IOException {
		if (!file.exists()) {
			file.getParentFile().mkdirs();
			if (!file.createNewFile()) return false;
		}
		savedFiles.put(file.getAbsolutePath(),reader.readFile(file));
		return true;
	}
	
	
	
	public boolean loadImageToCache(InputStream inputStream, class_2960 id) throws IOException {
		if (savedImages.containsKey(id)) {
			mc.method_1531().method_4615(id);
			savedImages.get(id).close();
			savedImages.remove(id);
		}
		class_1011 img = class_1011.method_4309(inputStream);
		class_1043 tex = new class_1043(id::method_12832,img);
		mc.method_1531().method_4616(id, tex);
		
		savedImages.put(id,tex);
		return true;
	}
	
	
	
	/**
	 * Clears Cache
	 */
	public void clearCache() {
		for (Entry<class_2960, class_1043> v : savedImages.entrySet()) {
			mc.method_1531().method_4615(v.getKey());
			v.getValue().close();
		}
		savedImages.clear();
		savedFiles.clear();
		savedFilesStrings.clear();
	}
	
	public static interface Reader {
		public byte[] readFile(File f) throws IOException;
	}
	
	/**
	 * @deprecated Very limited
	 */
	@Deprecated(since = "8.6.0", forRemoval = true)
	public static class ScannerReader implements Reader {
		
		public byte[] readFile(File file) throws IOException {
			Scanner reader = new Scanner(file);
			String res = "";
			while (reader.hasNextLine()) {
				res += reader.nextLine();
				res += '\n';
			}
			reader.close();
			if (res.isEmpty()) return res.getBytes();
			return res.substring(0, res.length()-1).getBytes();
		}
		
	}
	
	public static class FilesRABReader implements Reader {
		
		public byte[] readFile(File file) throws IOException {
			return Files.readAllBytes(file.toPath());
		}
		
	}
}
