package io.github.ngspace.hudder.utils.testing;

import java.util.HashMap;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.v2runtime.V2Runtime;

public class HudderUnitTest {
	public final ATextCompiler compiler;
	public final String texttocompile;
	public final String expectation;
	public HudderUnitTest(String texttocompile, ATextCompiler compiler, String topleftexpectation) {
		this.compiler = compiler;
		this.texttocompile = texttocompile;
		this.expectation = topleftexpectation.replace('&', '\u00A7');
	}
	
	
	
	public HudderUnitTestResult test(HudderConfig info) {
		String text = null;
		Hudder.log("Running unit test: " + texttocompile);
		try {
			if (compiler instanceof AV2Compiler v2comp) {
				v2comp.runtimes = new HashMap<String, V2Runtime>();
				AV2Compiler.tempVariables = new HashMap<String, Object>();
			}
			ATextCompiler.variables.clear();
			text = compiler.compile(info, texttocompile, "Unit Tests").TopLeftText;
		} catch (Exception e) {
			e.printStackTrace();
			text = e.getMessage();
		}
		return new HudderUnitTestResult(expectation.equals(text), expectation.replaceAll("(^ )|( $)", "~"),
				text.replaceAll("(^ )|( $)", "~"));
	}
	
	
	
	public static class HudderUnitTestResult {
		public final boolean isSucessful;
		public final String expectation;
		public final String result;

		public HudderUnitTestResult(boolean isSucessful, String expectation, String result) {
			this.isSucessful = isSucessful;
			this.expectation = expectation;
			this.result = result;
		}
		public class_5250 toText(String name) {
			var message = class_2561.method_43470(name + ": ").method_54663(0x0fa1fc)
					.method_10852(class_2561.method_43470((isSucessful?"Passed":"Failed")).method_54663(isSucessful?0x0fff3f:0xff0000));
			Hudder.log("Test name: "+name);
			Hudder.log("Expectation: "+expectation);
			Hudder.log("Result: "+result);
			Hudder.log("Success: "+isSucessful);
			Hudder.log("");
			if (!isSucessful) message.method_10852(getFailureMessage());
			return message;
		}
		
		public class_5250 getFailureMessage() {
			var message = class_2561.method_43470("");
			message.method_10852(class_2561.method_43470("\n  Expected:\n").method_54663(0x000cff));
			message.method_10852(class_2561.method_43470("    " + expectation.replace("\n", "\n    ")).method_54663(0xffffff));
			message.method_10852(class_2561.method_43470("\n  Got:\n").method_54663(0x000cff));
			message.method_10852(class_2561.method_43470("    " + result.replace("\n", "\n    ")).method_54663(0xffffff));
			return message;
		}
	}
}
