/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.data_management.api;

import io.github.ngspace.hudder.data_management.ObjectDataAPI;
import io.github.ngspace.hudder.data_management.api.DataVariable;
import io.github.ngspace.hudder.data_management.api.VariableTypes;
import java.util.HashMap;
import java.util.Map;

public class DataVariableRegistry {
    private static Map<String, DataVariable<?>> BooleanVariables;
    private static Map<String, DataVariable<?>> StringVariables;
    private static Map<String, DataVariable<?>> NumberVariables;
    private static Map<String, DataVariable<?>> ObjectVariables;
    private static Map<String, DataVariable<?>> AllVariables;

    private DataVariableRegistry() {
    }

    static void registerLegacyVariableSystem() {
        ObjectDataAPI.addObjectGetter(key -> {
            DataVariable<?> variable = ObjectVariables.get(key);
            if (variable != null) {
                return variable.getValue((String)key);
            }
            return null;
        });
    }

    public static void registerVariable(DataVariable<Object> variable, String ... names) {
        DataVariableRegistry.registerVariable(variable, VariableTypes.OBJECT, names);
    }

    public static <T> void registerVariable(DataVariable<?> variable, VariableTypes.Type<T> type, String ... names) {
        Map<String, DataVariable<?>> typemap = ObjectVariables;
        if (type == VariableTypes.NUMBER) {
            typemap = NumberVariables;
        }
        if (type == VariableTypes.STRING) {
            typemap = StringVariables;
        }
        if (type == VariableTypes.BOOLEAN) {
            typemap = BooleanVariables;
        }
        for (String name : names) {
            typemap.put(name.toLowerCase(), variable);
            AllVariables.put(name.toLowerCase(), variable);
        }
    }

    public static String getString(String key) {
        DataVariable<?> v = StringVariables.get(key);
        return v == null ? null : (String)v.getValue(key);
    }

    public static Double getNumber(String key) {
        DataVariable<?> v = NumberVariables.get(key);
        return v == null ? null : Double.valueOf(((Number)v.getValue(key)).doubleValue());
    }

    public static Boolean getBoolean(String key) {
        DataVariable<?> v = BooleanVariables.get(key);
        return v == null ? null : (Boolean)v.getValue(key);
    }

    public static Object getObject(String key) {
        DataVariable<?> v = ObjectVariables.get(key);
        return v == null ? null : v.getValue(key);
    }

    public static Object getAny(String key) {
        DataVariable<?> v = AllVariables.get(key);
        return v == null ? null : v.getValue(key);
    }

    public static boolean hasVariable(String key) {
        return AllVariables.containsKey(key);
    }

    static {
        DataVariableRegistry.registerLegacyVariableSystem();
        BooleanVariables = new HashMap();
        StringVariables = new HashMap();
        NumberVariables = new HashMap();
        ObjectVariables = new HashMap();
        AllVariables = new HashMap();
    }
}

