/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.utils.testing;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.testing.HudderUnitTest;
import io.github.ngspace.hudder.utils.testing.HudderUnitTestingCommand;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;

public class HudderUnitTester {
    public ATextCompiler compiler;
    public Map<String, HudderUnitTest> UnitTests = new HashMap<String, HudderUnitTest>();

    public HudderUnitTester(ATextCompiler compiler) {
        this.compiler = compiler;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
    }

    public void load(String contents) {
        String[] conds;
        for (String st : conds = ("\n" + contents).split("\\n\\n\\|\\|INPUT\\|\\|")) {
            if (st.isBlank()) continue;
            String[] content = st.split("\n", 2);
            String[] inputandExpectation = content[1].split("\\n\\|\\|EXPECT\\|\\|\\n");
            if (this.UnitTests.containsKey(content[0])) {
                Hudder.alert("Repeating key: " + content[0]);
            }
            this.UnitTests.put(content[0], new HudderUnitTest(inputandExpectation[0], this.compiler, inputandExpectation[1]));
        }
        HudderUnitTestingCommand.UnitTestsSuggestionProvider.suggestions = new ArrayList<String>(this.UnitTests.keySet());
    }

    public HudderUnitTest.HudderUnitTestResult test(HudderConfig info, String name) {
        return this.UnitTests.get(name).test(info);
    }

    public class_5250 testAll(HudderConfig config) {
        class_5250 result = class_2561.method_43470((String)"All tests:\n");
        boolean failed = false;
        Instant start = Instant.now();
        HashMap<HudderUnitTest.HudderUnitTestResult, String> failedtests = new HashMap<HudderUnitTest.HudderUnitTestResult, String>();
        for (String name : this.UnitTests.keySet()) {
            HudderUnitTest.HudderUnitTestResult testresult = this.test(config, name);
            result.method_27693("\n").method_10852((class_2561)testresult.toText(name));
            if (testresult.isSucessful) continue;
            failed = true;
            failedtests.put(testresult, name);
        }
        Instant end = Instant.now();
        if (failed) {
            result.method_10852((class_2561)class_2561.method_43470((String)"\n\nFailed the following tests: ").method_54663(0xFF0000));
            for (Map.Entry failedtest : failedtests.entrySet()) {
                result.method_27693("\n\n");
                result.method_10852((class_2561)class_2561.method_43470((String)((String)failedtest.getValue())).method_54663(0xFF0000));
                result.method_27693(":");
                result.method_10852((class_2561)((HudderUnitTest.HudderUnitTestResult)failedtest.getKey()).getFailureMessage());
            }
        }
        result.method_10852((class_2561)class_2561.method_43470((String)this.milliseconds(!failed, start, end, failedtests.size(), this.UnitTests.size())));
        return result;
    }

    private String milliseconds(boolean success, Instant start, Instant end, int failedcount, int testscount) {
        double v = (double)Duration.between(start, end).toNanos() / 1000000.0;
        double res = (int)(v * 1000.0);
        return "\n\n" + (success ? "Successful, " : "") + "took " + (res /= 1000.0) + "ms. Passed " + (testscount - failedcount) + "/" + testscount + " tests.";
    }
}

