/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.v2runtime.runtime_elements.AV2RuntimeElement;
import java.util.Arrays;
import java.util.HashMap;

public class V2Runtime {
    public final AV2Compiler compiler;
    protected V2Runtime scope;
    public static final Object NULL = new Object(){

        public boolean equals(Object obj) {
            return obj == this || obj == null;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "null";
        }
    };
    protected AV2RuntimeElement[] elements = new AV2RuntimeElement[0];
    public CompileState compileState;
    HashMap<String, Object> scopedVariables = new HashMap();

    public V2Runtime(AV2Compiler compiler, V2Runtime scope) {
        this.compiler = compiler;
        this.scope = scope;
    }

    public CompileState execute() throws CompileException {
        this.compileState = new CompileState("topleft");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            AV2RuntimeElement element = this.elements[i];
            if (element.execute(this.compileState, builder) && !this.compileState.hasReturned) continue;
            this.compileState.hasBroken = true;
            break;
        }
        this.compileState.addString(builder.toString(), false);
        return this.compileState;
    }

    public void addRuntimeElement(AV2RuntimeElement element) {
        this.elements = V2Runtime.addToArray(this.elements, element);
    }

    public AV2RuntimeElement[] getElements() {
        return this.elements;
    }

    public static <T> T[] addToArray(T[] arr, T t) {
        T[] newarr = Arrays.copyOf(arr, arr.length + 1);
        newarr[arr.length] = t;
        return newarr;
    }

    public void putScoped(String name, Object value) {
        this.scopedVariables.put(name, value);
    }

    public Object getScoped(String name) {
        Object object = this.scopedVariables.get(name);
        if (object == null && this.scope != null) {
            return this.scope.getScoped(name);
        }
        return object;
    }

    public Object getVariable(String name) {
        Object object = this.getScoped(name);
        if (object == null) {
            return this.compiler.getDynamicVariable(name);
        }
        return object;
    }
}

