/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.methods;

import com.mojang.datafixers.types.templates.List;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.CompileState;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.ObjectWrapper;
import io.github.ngspace.hudder.v2runtime.methods.IMethod;
import io.github.ngspace.hudder.v2runtime.methods.ItemStackMethods;
import io.github.ngspace.hudder.v2runtime.methods.LoadMethod;
import java.util.HashMap;
import java.util.Map;

public class MethodHandler {
    public static Map<String, IMethod> methods = new HashMap<String, IMethod>();
    public static final String[] Var = new String[]{"[Variable]"};
    public static final String[] TextArg = new String[]{"[Text]"};

    public MethodHandler() {
        this.bindConsumer((IMethod)new ItemStackMethods(), "slot", "item", "hand", "selectedslot", "hat", "helmet", "chestplate", "leggings", "pants", "boots", "offhand");
        this.bindConsumer((HudderConfig c, CompileState m, ATextCompiler a, String t, int l, int ch, ObjectWrapper[] s) -> m.setTextLocation(t, (float)(s.length > 0 ? s[0].asDouble() : (double)c.scale)), "bottomright", "topleft", "topright", "bottomleft", "mute");
        this.bindConsumer((IMethod)new LoadMethod(), "load", "execute", "compile", "run", "add");
        this.bindConsumer((HudderConfig c, CompileState m, ATextCompiler a, String t, int l, int ch, ObjectWrapper[] s) -> {
            throw new CompileException(s[0].asString(), l, ch);
        }, 1, TextArg, "throw");
    }

    public void bindConsumer(IMethod method, String ... names) {
        for (String name : names) {
            methods.put(name.toLowerCase(), method);
        }
    }

    public void bindConsumer(IMethod method, int length, String[] args, String ... names) {
        IMethod newmethod = (config, meta, compiler, name, l, c, vals) -> {
            if (vals.length < length) {
                String err = "\"" + name + "\" only accepts ;" + name;
                for (String str : args) {
                    err = err + ", " + str;
                }
                err = err + ";";
                throw new CompileException(err, l, c);
            }
            method.invoke(config, meta, compiler, name, l, c, vals);
        };
        this.bindConsumer(newmethod, names);
    }

    public IMethod getMethodFromName(String name) throws CompileException {
        IMethod method = methods.get(name.toLowerCase().trim());
        if (method == null) {
            throw new CompileException("Unknown method " + name);
        }
        return method;
    }

    @Deprecated(since="7.2.0", forRemoval=true)
    public void register(String method, String[] argtypes, String name, int defline, int defcharpos, String filename) {
        int[] parameters = new int[argtypes.length];
        for (int i = 0; i < argtypes.length; ++i) {
            if ("string".equals(argtypes[i].trim())) {
                parameters[i] = 1;
                continue;
            }
            if ("number".equals(argtypes[i].trim())) {
                parameters[i] = 2;
                continue;
            }
            if ("boolean".equals(argtypes[i].trim())) {
                parameters[i] = 3;
                continue;
            }
            if ("array".equals(argtypes[i].trim())) {
                parameters[i] = 4;
                continue;
            }
            if ("any".equals(argtypes[i].trim())) {
                parameters[i] = 0;
                continue;
            }
            throw new UnsupportedOperationException("Can't recognize type: " + argtypes[i].trim());
        }
        String errb = "\"" + name + "\" only accepts ;" + name;
        for (String arg : argtypes) {
            errb = errb + ", [" + arg + "]";
        }
        String err = errb = errb + ";";
        IMethod newmethod = (info, state, comp, type, line, charpos, vals) -> {
            if (vals.length != argtypes.length) {
                throw new CompileException(err, defline, defcharpos);
            }
            for (int i = 0; i < vals.length; ++i) {
                if (parameters[i] == 1) {
                    comp.put("arg" + (i + 1), vals[i].asString());
                    continue;
                }
                if (parameters[i] == 2) {
                    comp.put("arg" + (i + 1), vals[i].asDouble());
                    continue;
                }
                if (parameters[i] == 3) {
                    comp.put("arg" + (i + 1), vals[i].asBoolean());
                    continue;
                }
                if (parameters[i] == 4) {
                    comp.put("arg" + (i + 1), vals[i].asType(List.class));
                    continue;
                }
                if (parameters[i] != 0) continue;
                comp.put("arg" + (i + 1), vals[i].get());
            }
            try {
                state.combineWithResult(comp.compile(info, method, filename), false);
            }
            catch (CompileException e) {
                throw new CompileException(e.getFailureMessage() + "\nMethod " + type + " threw an error ", line, charpos);
            }
        };
        methods.put(name, newmethod);
    }
}

