/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.helper.Codecs;
import org.cyclops.integrateddynamics.core.part.event.PartWriterAspectEvent;

public class PartWriterAspectTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codecs.PART_TYPE.optionalFieldOf("parttype").forGetter(Instance::partType), (App)Codecs.ASPECT.optionalFieldOf("aspect").forGetter(Instance::aspect), (App)Codecs.VARIABLE.optionalFieldOf("variable").forGetter(Instance::variablePredicate)).apply((Applicative)p_311401_, Instance::new));

    public PartWriterAspectTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void test(ServerPlayer player, PartWriterAspectEvent event) {
        this.trigger(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onEvent(PartWriterAspectEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getEntityPlayer(), event);
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<IPartType> partType, Optional<IAspect> aspect, Optional<VariablePredicate> variablePredicate) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<PartWriterAspectEvent>
    {
        public boolean test(ServerPlayer player, PartWriterAspectEvent event) {
            return !(!this.partType.isEmpty() && event.getPartType() != this.partType.get() || !this.aspect.isEmpty() && event.getAspect() != this.aspect.get() || !this.variablePredicate.orElse(VariablePredicate.ANY).test(((IPartStateWriter)event.getPartState()).getVariable(event.getNetwork(), event.getPartNetwork(), ValueDeseralizationContext.of(player.level()))));
        }
    }
}

