/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.codec.ListCodecStrict;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerSqueezer
implements RecipeSerializer<RecipeSqueezer> {
    public static final Codec<RecipeSqueezer.IngredientChance> CODEC_INGREDIENT_CHANCE = RecipeSerializerHelpers.getCodecItemStackOrTagChance(() -> GeneralConfig.recipeTagOutputModPriorities).xmap(RecipeSqueezer.IngredientChance::new, RecipeSqueezer.IngredientChance::getIngredientChance);
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeSqueezer.IngredientChance> STREAM_CODEC_INGREDIENT_CHANCE = RecipeSerializerHelpers.STREAM_CODEC_ITEMSTACK_OR_ITEMSTACKINGREDIENT_CHANCE.map(RecipeSqueezer.IngredientChance::new, RecipeSqueezer.IngredientChance::getIngredientChance);
    public static final MapCodec<RecipeSqueezer> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input_item").forGetter(RecipeSqueezer::getInputIngredient), (App)new ListCodecStrict(CODEC_INGREDIENT_CHANCE).optionalFieldOf("output_items").forGetter(r -> r.getOutputItems().isEmpty() ? Optional.empty() : Optional.of(r.getOutputItems().stream().toList())), (App)FluidStack.CODEC.optionalFieldOf("output_fluid").forGetter(RecipeSqueezer::getOutputFluid)).apply((Applicative)builder, (inputIngredient, outputItemStacks, outputFluid) -> {
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        return new RecipeSqueezer((Ingredient)inputIngredient, (NonNullList<RecipeSqueezer.IngredientChance>)outputItemStacks.map(NonNullList::copyOf).orElseGet(NonNullList::create), (Optional<FluidStack>)outputFluid);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeSqueezer> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RecipeSqueezer::getInputIngredient, (StreamCodec)STREAM_CODEC_INGREDIENT_CHANCE.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), RecipeSqueezer::getOutputItems, (StreamCodec)ByteBufCodecs.optional((StreamCodec)FluidStack.STREAM_CODEC), RecipeSqueezer::getOutputFluid, RecipeSqueezer::new);

    public MapCodec<RecipeSqueezer> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, RecipeSqueezer> streamCodec() {
        return STREAM_CODEC;
    }
}

