/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class AspectAppendix
extends SectionAppendix {
    private static final int SLOT_SIZE = 16;
    private final IAspect aspect;
    private ItemStack itemStack;

    public AspectAppendix(IInfoBook infoBook, IAspect aspect) {
        super(infoBook);
        this.aspect = aspect;
    }

    protected int getOffsetY() {
        return 5;
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeight() {
        return 30 + (this.aspect.hasProperties() ? 10 * (this.aspect.getPropertyTypes().size() + 1) : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = 5;
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)"aspect.integrateddynamics.name", (Object[])new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt((int)120, (int)20, (int)30));
        Lighting.setupForFlatItems();
        guiGraphics.renderItem(this.itemStack, x, y);
        String aspectName = L10NHelpers.localize((String)this.aspect.getTranslationKey(), (Object[])new Object[0]);
        String valueTypeName = L10NHelpers.localize((String)this.aspect.getValueType().getTranslationKey(), (Object[])new Object[0]);
        gui.drawScaledCenteredString(guiGraphics, L10NHelpers.localize((String)aspectName, (Object[])new Object[0]), x + 10, y + 8, width, 1.0f, gui.getBannerWidth() - 10, 0);
        String valueString = L10NHelpers.localize((String)(String.valueOf(this.aspect.getValueType().getDisplayColorFormat()) + valueTypeName), (Object[])new Object[0]);
        gui.getFont().drawInBatch(L10NHelpers.localize((String)(this.aspect instanceof IAspectWrite ? "gui.integrateddynamics.input" : "gui.integrateddynamics.output"), (Object[])new Object[]{valueString}), (float)x, (float)(y + 16), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (this.aspect.hasProperties()) {
            int offsetY = 26;
            gui.getFont().drawInBatch(String.valueOf(ChatFormatting.DARK_GRAY) + L10NHelpers.localize((String)"gui.integrateddynamics.part.properties", (Object[])new Object[0]), (float)x, (float)(y + offsetY), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            for (IAspectPropertyTypeInstance property : this.aspect.getPropertyTypes()) {
                gui.getFont().drawInBatch(String.valueOf(ChatFormatting.DARK_GRAY) + L10NHelpers.localize((String)property.getTranslationKey(), (Object[])new Object[0]), (float)(x + 10), (float)(y + (offsetY += 10)), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16) {
            ArrayList lines = Lists.newArrayList();
            this.aspect.loadTooltip(lines, true);
            guiGraphics.renderComponentTooltip(gui.getFont(), (List)lines, mx, my);
        }
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    public void preBakeElement(InfoSection infoSection) {
    }

    public void bakeElement(InfoSection infoSection) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        this.itemStack = registry.writeVariableFacadeItem(new ItemStack(RegistryEntries.ITEM_VARIABLE), new AspectVariableFacade(false, 0, this.aspect), Aspects.REGISTRY);
    }
}

