/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;

public abstract class PartStateActiveVariableBase<P extends IPartType>
extends PartStateBase<P> {
    private boolean checkedForWriteVariable = false;
    protected IVariableFacade currentVariableFacade = null;
    private final IVariableContainer variableContainer;
    private boolean deactivated = false;
    private SimpleInventory inventory;
    private List<MutableComponent> globalErrorMessages = Lists.newLinkedList();
    private boolean retryEvaluation = false;

    public PartStateActiveVariableBase(int inventorySize) {
        this.inventory = new SingularInventory(inventorySize);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.variableContainer = new VariableContainerDefault();
        this.addVolatileCapability(Capabilities.VariableContainer.PART, Optional.of(this.variableContainer));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    protected void validate(INetwork network, IPartNetwork partNetwork) {
        this.currentVariableFacade.validate(network, partNetwork, new Validator(this), this.currentVariableFacade.getOutputType());
    }

    protected void onCorruptedState() {
        IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, "A corrupted part state was found at, repairing...");
        Thread.dumpStack();
        this.checkedForWriteVariable = false;
        this.deactivated = true;
    }

    public boolean hasVariable() {
        return (this.getGlobalErrors().isEmpty() || this.isRetryEvaluation()) && !this.getInventory().isEmpty();
    }

    public <V extends IValue> IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork, ValueDeseralizationContext valueDeseralizationContext) {
        if (!this.checkedForWriteVariable) {
            if (this.variableContainer.getVariableCache().isEmpty()) {
                this.variableContainer.refreshVariables(network, (Container)this.inventory, false, valueDeseralizationContext);
            }
            for (IVariableFacade facade : this.variableContainer.getVariableCache().values()) {
                if (facade == null) continue;
                this.currentVariableFacade = facade;
                this.validate(network, partNetwork);
            }
            this.checkedForWriteVariable = true;
        }
        if (this.currentVariableFacade == null) {
            this.onCorruptedState();
            return null;
        }
        return this.currentVariableFacade.getVariable(network, partNetwork);
    }

    public void onVariableContentsUpdated(P partType, PartTarget target) {
        this.checkedForWriteVariable = false;
        this.addGlobalError(null);
        this.currentVariableFacade = null;
        PartPos center = target.getCenter();
        Level level = center.getPos().getLevel(true);
        NetworkHelpers.getNetwork((ILevelExtension)level, center.getPos().getBlockPos(), center.getSide()).ifPresent(network -> this.variableContainer.refreshVariables((INetwork)network, (Container)this.inventory, false, ValueDeseralizationContext.of(level)));
    }

    public List<MutableComponent> getGlobalErrors() {
        return this.globalErrorMessages;
    }

    public void addGlobalError(MutableComponent error) {
        this.setRetryEvaluation(false);
        if (error == null) {
            this.globalErrorMessages.clear();
        } else {
            this.globalErrorMessages.add(error);
        }
        this.onDirty();
        this.sendUpdate();
    }

    @Override
    public void writeToNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
        super.writeToNBT(valueDeseralizationContext, tag);
        NBTClassType.writeNbt(List.class, (String)"globalErrorMessages", this.globalErrorMessages, (CompoundTag)tag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
        this.inventory.writeToNBT(valueDeseralizationContext.holderLookupProvider(), tag, "inventory");
    }

    @Override
    public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
        super.readFromNBT(valueDeseralizationContext, tag);
        this.globalErrorMessages = (List)NBTClassType.readNbt(List.class, (String)"globalErrorMessages", (CompoundTag)tag, (HolderLookup.Provider)valueDeseralizationContext.holderLookupProvider());
        this.inventory.readFromNBT(valueDeseralizationContext.holderLookupProvider(), tag, "inventory");
    }

    @Override
    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == Capabilities.ValueInterface.PART) {
            IVariable variable;
            if (this.hasVariable() && (variable = this.getVariable(network, partNetwork, ValueDeseralizationContext.of(target.getCenter().getPos().getLevel(true)))) != null) {
                return Optional.of(() -> Optional.of(variable.getValue()));
            }
            return Optional.empty();
        }
        return super.getCapability(partType, capability, network, partNetwork, target);
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    public boolean isRetryEvaluation() {
        return this.retryEvaluation;
    }

    public void setRetryEvaluation(boolean retryEvaluation) {
        this.retryEvaluation = retryEvaluation;
    }

    public static class SingularInventory
    extends SimpleInventory {
        public SingularInventory(int size) {
            super(size, 1);
        }

        protected boolean canInsert(int slot) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                if (i == slot || this.getItem(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean canPlaceItem(int i, ItemStack itemstack) {
            return this.canInsert(i) && super.canPlaceItem(i, itemstack);
        }
    }

    public static class Validator
    implements IVariableFacade.IValidator {
        private final PartStateActiveVariableBase state;

        public Validator(PartStateActiveVariableBase state) {
            this.state = state;
        }

        @Override
        public void addError(MutableComponent error) {
            this.state.addGlobalError(error);
        }
    }
}

