/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.level;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.PartOffsetsClientNotifier;
import org.cyclops.integrateddynamics.network.packet.PartOffsetsSubscribePacket;

public class PartOffsetsOverlayRenderer {
    public static final RenderType RENDER_TYPE_LINE = RenderType.create((String)"integrateddynamicsline", (int)128, (RenderPipeline)RenderPipelines.SECONDARY_BLOCK_OUTLINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).createCompositeState(false));
    private static final PartOffsetsOverlayRenderer _INSTANCE = new PartOffsetsOverlayRenderer();
    private boolean subscribedToServerChanges = false;
    private List<PartOffsetsClientNotifier.Entry> data = Lists.newArrayList();

    private PartOffsetsOverlayRenderer() {
    }

    public static PartOffsetsOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    private void subscribeToServerChanges() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PartOffsetsSubscribePacket(true));
        this.subscribedToServerChanges = true;
    }

    private void unsubscribeToServerChanges() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PartOffsetsSubscribePacket(false));
        this.subscribedToServerChanges = false;
    }

    public void clear() {
        this.data.clear();
    }

    public void setData(List<PartOffsetsClientNotifier.Entry> data) {
        this.data = data;
    }

    @SubscribeEvent
    public void onRender(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is(WrenchHelpers.TAG_WRENCH) || player.getItemInHand(InteractionHand.OFF_HAND).is(WrenchHelpers.TAG_WRENCH)) {
            if (!this.subscribedToServerChanges) {
                this.subscribeToServerChanges();
            }
            Vec3 eyePos = event.getCamera().getPosition();
            for (PartOffsetsClientNotifier.Entry entry : this.data) {
                this.renderOffset(event.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().outlineBufferSource(), entry, eyePos);
            }
        } else if (this.subscribedToServerChanges) {
            this.data.clear();
            this.unsubscribeToServerChanges();
        }
    }

    private void renderOffset(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, PartOffsetsClientNotifier.Entry entry, Vec3 eyePos) {
        double offsetX = eyePos.x;
        double offsetY = eyePos.y;
        double offsetZ = eyePos.z;
        Random posRand = new Random(entry.source().asLong());
        float r = 0.5f + posRand.nextFloat() / 2.0f;
        float g = 0.5f + posRand.nextFloat() / 2.0f;
        float b = 0.5f + posRand.nextFloat() / 2.0f;
        float a = 0.9f;
        VertexConsumer vb = renderTypeBuffer.getBuffer(RENDER_TYPE_LINE);
        float minX = (float)entry.source().getX() - (float)offsetX + 0.5f + (float)entry.sourceSide().getStepX() * 0.5f;
        float minY = (float)entry.source().getY() - (float)offsetY + 0.5f + (float)entry.sourceSide().getStepY() * 0.5f;
        float minZ = (float)entry.source().getZ() - (float)offsetZ + 0.5f + (float)entry.sourceSide().getStepZ() * 0.5f;
        float maxX = (float)entry.source().getX() - (float)offsetX + 0.5f + (float)entry.targetOffset().getX() + (entry.targetSide().getAxis() != entry.sourceSide().getAxis() ? (float)entry.targetSide().getStepX() * 0.5f : 0.0f);
        float maxY = (float)entry.source().getY() - (float)offsetY + 0.5f + (float)entry.targetOffset().getY() + (entry.targetSide().getAxis() != entry.sourceSide().getAxis() ? (float)entry.targetSide().getStepY() * 0.5f : 0.0f);
        float maxZ = (float)entry.source().getZ() - (float)offsetZ + 0.5f + (float)entry.targetOffset().getZ() + (entry.targetSide().getAxis() != entry.sourceSide().getAxis() ? (float)entry.targetSide().getStepZ() * 0.5f : 0.0f);
        vb.addVertex(matrixStack.last().pose(), minX, minY, minZ).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 0.0f);
        vb.addVertex(matrixStack.last().pose(), maxX, maxY, maxZ).setColor(r, g, b, a).setNormal(0.0f, 0.0f, 0.0f);
        AABB bb = new AABB(entry.targetSide().getStepX() == 1 ? 0.9 : 0.0, entry.targetSide().getStepY() == 1 ? 0.9 : 0.0, entry.targetSide().getStepZ() == 1 ? 0.9 : 0.0, entry.targetSide().getStepX() == -1 ? 0.1 : 1.0, entry.targetSide().getStepY() == -1 ? 0.1 : 1.0, entry.targetSide().getStepZ() == -1 ? 0.1 : 1.0);
        bb = bb.move(entry.source()).move((double)entry.targetOffset().getX(), (double)entry.targetOffset().getY(), (double)entry.targetOffset().getZ()).move(-offsetX, -offsetY, -offsetZ).inflate(0.05, 0.05, 0.05).inflate(-0.05, -0.05, -0.05);
        ShapeRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)renderTypeBuffer.getBuffer(RenderType.lines()), (AABB)bb, (float)r, (float)g, (float)b, (float)a);
    }
}

