/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class OperatorValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final int MAX_LINES = 30;
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Font fontRenderer = context.getFont();
        float maxWidth = 0.0f;
        ValueTypeOperator.ValueOperator valueOperator = (ValueTypeOperator.ValueOperator)value;
        IOperator operator = valueOperator.getRawValue();
        LinkedList lines = Lists.newLinkedList();
        lines.add(Component.literal((String)(ValueTypes.OPERATOR.getName(valueOperator) + " ::")));
        lines.addAll(ValueTypeOperator.getSignatureLines(operator, true));
        for (Component line : lines) {
            float width = fontRenderer.width(line.getString()) - 1;
            maxWidth = Math.max(maxWidth, width);
        }
        Objects.requireNonNull(fontRenderer);
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.size();
        matrixStack.pushPose();
        float scaleX = 12.5f / (maxWidth * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = maxWidth * scale;
        float newHeight = totalHeight * scale;
        matrixStack.translate((12.5f - newWidth) / 2.0f, (12.5f - newHeight) / 2.0f, 0.0f);
        matrixStack.scale(scale, scale, 1.0f);
        int offset = 0;
        for (Component line : lines) {
            int color = IModHelpers.get().getBaseHelpers().addAlphaToColor(ValueTypes.OPERATOR.getDisplayColor(), alpha);
            context.getFont().drawInBatch(line.getString(), 0.0f, (float)offset, color, false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.popPose();
    }
}

