/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;

public class CommandTest
implements Command<CommandSourceStack> {
    public static final String P = "org.cyclops.integrateddynamics.gametest.integration.";
    public static final List<String> CLASSES = Lists.newArrayList((Object[])new String[]{"org.cyclops.integrateddynamics.gametest.integration.TestVariables", "org.cyclops.integrateddynamics.gametest.integration.TestBlockOperators", "org.cyclops.integrateddynamics.gametest.integration.TestItemStackOperators", "org.cyclops.integrateddynamics.gametest.integration.TestEntityOperators", "org.cyclops.integrateddynamics.gametest.integration.TestFluidStackOperators", "org.cyclops.integrateddynamics.gametest.integration.TestIngredientsOperators", "org.cyclops.integrateddynamics.gametest.integration.TestRecipeOperators"});

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.literal((String)"Running tests..."));
        try {
            if (!this.test()) {
                ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.literal((String)"There were failing tests, see results in console."));
            } else {
                ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.literal((String)"All tests succeeded!"));
            }
            return 0;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return 1;
        }
    }

    protected boolean test() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        int ok = 0;
        int total = 0;
        for (String className : CLASSES) {
            try {
                Class<?> clazz = Class.forName(className);
                Object testInstance = clazz.newInstance();
                LinkedList befores = Lists.newLinkedList();
                HashMap tests = Maps.newHashMap();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.isAnnotationPresent(IntegrationBefore.class)) {
                        befores.add(method);
                    }
                    if (!method.isAnnotationPresent(IntegrationTest.class)) continue;
                    tests.put(method, false);
                }
                for (Method test : tests.keySet()) {
                    boolean testOk;
                    String testName = className.replace(P, "") + "#" + test.getName();
                    for (Method before : befores) {
                        before.invoke(testInstance, new Object[0]);
                    }
                    try {
                        test.invoke(testInstance, new Object[0]);
                        testOk = true;
                    }
                    catch (InvocationTargetException e) {
                        Class<?> excepted = test.getAnnotation(IntegrationTest.class).expected();
                        if (!excepted.isInstance(e.getTargetException())) {
                            testOk = false;
                            if (e.getTargetException() instanceof IllegalStateException || e.getTargetException() instanceof AssertionError) {
                                System.err.println("Test " + testName + " failed!");
                                e.getTargetException().printStackTrace();
                            } else {
                                System.err.println(String.format("Expected at %s exception %s, but found:", testName, e));
                                e.getTargetException().printStackTrace();
                            }
                        }
                        testOk = true;
                    }
                    tests.put(test, testOk);
                }
                for (Boolean result : tests.values()) {
                    if (!result.booleanValue()) continue;
                    ++ok;
                }
                total += tests.size();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Skipped test class: " + className);
            }
        }
        System.err.println(String.format("Tests succeeded: %s/%s", ok, total));
        return ok == total;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"test").requires(commandSource -> commandSource.hasPermission(2))).executes((Command)new CommandTest());
    }
}

