/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;

public abstract class PositionedOperator
extends OperatorBase
implements INBTProvider {
    private DimPos pos;
    private Direction side;

    protected PositionedOperator(String symbol, String operatorName, String interactName, IValueType[] inputTypes, IValueType outputType, OperatorBase.IFunction function, IConfigRenderPattern renderPattern, DimPos pos, Direction side) {
        super(symbol, operatorName, interactName, null, false, inputTypes, outputType, function, renderPattern);
        this.pos = pos;
        this.side = side;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public void writeGeneratedFieldsToNBT(ValueOutput output) {
        NBTClassType.writeNbt(DimPos.class, (String)"pos", (Object)this.pos, (ValueOutput)output);
        NBTClassType.writeNbt(Direction.class, (String)"side", (Object)this.side, (ValueOutput)output);
    }

    public void readGeneratedFieldsFromNBT(ValueInput input) {
        this.pos = (DimPos)NBTClassType.readNbt(DimPos.class, (String)"pos", (ValueInput)input);
        this.side = (Direction)NBTClassType.readNbt(Direction.class, (String)"side", (ValueInput)input);
    }

    public DimPos getPos() {
        return this.pos;
    }

    public void setPos(DimPos pos) {
        this.pos = pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public void setSide(Direction side) {
        this.side = side;
    }

    public static class Serializer
    implements IOperatorSerializer<PositionedOperator> {
        private final Class<? extends PositionedOperator> clazz;
        private final ResourceLocation uniqueName;

        public Serializer(Class<? extends PositionedOperator> clazz, ResourceLocation uniqueName) {
            this.clazz = clazz;
            this.uniqueName = uniqueName;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return this.clazz.isInstance(operator);
        }

        @Override
        public ResourceLocation getUniqueName() {
            return this.uniqueName;
        }

        @Override
        public void serialize(ValueOutput valueOutput, PositionedOperator operator) {
            operator.writeGeneratedFieldsToNBT(valueOutput);
        }

        @Override
        public PositionedOperator deserialize(ValueInput valueInput) throws EvaluationException {
            try {
                Constructor<? extends PositionedOperator> constructor = this.clazz.getConstructor(new Class[0]);
                PositionedOperator proxy = constructor.newInstance(new Object[0]);
                proxy.readGeneratedFieldsFromNBT(valueInput);
                return proxy;
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new EvaluationException(Component.translatable((String)"valuetype.integrateddynamics.error.deserialize", (Object[])new Object[]{valueInput.toString(), e.getMessage()}));
            }
        }
    }
}

