/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PartTypeAdapter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;
import org.cyclops.integrateddynamics.item.ItemEnhancement;
import org.cyclops.integrateddynamics.item.ItemWrench;

public abstract class PartTypeBase<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeAdapter<P, S> {
    private Item item;
    private Block block;
    private final String name;
    private final PartRenderPosition partRenderPosition;
    private final Map<Class<? extends INetworkEvent>, IEventAction> networkEventActions;

    public PartTypeBase(String name, PartRenderPosition partRenderPosition) {
        this.name = name;
        this.partRenderPosition = partRenderPosition;
        this.networkEventActions = this.constructNetworkEventActions();
        this.registerBlock();
    }

    @Override
    public ResourceLocation getUniqueName() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)this.name);
    }

    protected ModBaseNeoForge getMod() {
        return IntegratedDynamics._instance;
    }

    protected String getModId() {
        return this.getMod().getModId();
    }

    protected void registerBlock() {
        BlockConfigCommon<ModBaseNeoForge> blockConfig = new BlockConfigCommon<ModBaseNeoForge>(this.getMod(), "part_" + this.name, (eConfig, properties) -> {
            this.block = this.createBlock((BlockConfigCommon<?>)eConfig, (BlockBehaviour.Properties)properties);
            return this.block;
        }, (eConfig, block) -> {
            this.item = this.createItem((BlockConfigCommon<?>)eConfig, (Block)block);
            return this.item;
        }){

            public String getFullTranslationKey() {
                return PartTypeBase.this.getTranslationKey();
            }

            public Collection<ItemStack> getDefaultCreativeTabEntries() {
                return Collections.singleton(new ItemStack((ItemLike)this.getItemInstance()));
            }
        };
        this.getMod().getConfigHandler().addConfigurable((ExtendedConfigCommon)blockConfig);
    }

    protected Block createBlock(BlockConfigCommon<?> blockConfig, BlockBehaviour.Properties properties) {
        return new IgnoredBlock(properties);
    }

    protected Item createItem(BlockConfigCommon<?> blockConfig, Block block) {
        return new ItemPart(blockConfig.createDefaultItemProperties().overrideDescription(this.getTranslationKey()), this);
    }

    @Override
    public ResourceLocation getBlockModelPath() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)("part_" + this.name));
    }

    @Override
    protected String createTranslationKey() {
        return "parttype." + this.getModId() + "." + this.name;
    }

    @Override
    public INetworkElement createNetworkElement(IPartContainer partContainer, DimPos pos, Direction side) {
        return new PartNetworkElement(this, PartPos.of(pos, side));
    }

    @Override
    public InteractionResult onPartActivated(S partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        ItemWrench itemWrench;
        InteractionResult result;
        ItemEnhancement itemEnhancement;
        InteractionResult result2;
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        Item item = heldItem.getItem();
        if (item instanceof ItemEnhancement && (result2 = (itemEnhancement = (ItemEnhancement)item).applyEnhancement(this, partState, heldItem, player, hand)).consumesAction()) {
            return result2;
        }
        PartPos partPos = PartPos.of(world, pos, hit.getDirection());
        Item item2 = heldItem.getItem();
        if (item2 instanceof ItemWrench && (result = (itemWrench = (ItemWrench)item2).performPartAction(hit, this, partState, heldItem, player, hand, partPos)).consumesAction()) {
            return result;
        }
        if (this.getContainerProvider(partPos).isPresent()) {
            if (!world.isClientSide()) {
                return PartHelpers.openContainerPart((ServerPlayer)player, partPos, this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
        if (!saveState && state.getMaxOffset() > 0) {
            int offset;
            for (int remainingOffset = state.getMaxOffset(); remainingOffset > 0; remainingOffset -= offset) {
                offset = remainingOffset < GeneralConfig.enchancementOffsetPartDropValue ? remainingOffset : GeneralConfig.enchancementOffsetPartDropValue;
                ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_ENHANCEMENT_OFFSET);
                ((ItemEnhancement)((Object)RegistryEntries.ITEM_ENHANCEMENT_OFFSET.get())).setEnhancementValue(itemStack, offset);
                itemStacks.add(itemStack);
            }
            state.setMaxOffset(0);
        }
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        return (BlockState)this.getBlock().defaultBlockState().setValue(IgnoredBlock.FACING, (Comparable)side);
    }

    @Override
    public BlockState getBaseBlockState() {
        return this.getBlock().defaultBlockState();
    }

    @Override
    public void loadTooltip(S state, List<Component> lines) {
        if (!state.isEnabled()) {
            lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.disabled"));
        }
        lines.add((Component)Component.translatable((String)"item.integrateddynamics.general.id", (Object[])new Object[]{state.getId()}));
        if (state.getMaxOffset() > 0) {
            lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.maxoffset", (Object[])new Object[]{state.getMaxOffset()}));
        }
    }

    @Override
    public void loadTooltip(ItemStack itemStack, Consumer<Component> tooltipAdder) {
        if (itemStack.has(RegistryEntries.DATACOMPONENT_PART_STATE)) {
            CompoundTag tag = (CompoundTag)itemStack.get(RegistryEntries.DATACOMPONENT_PART_STATE);
            if (tag.contains("id")) {
                int id = (Integer)tag.getInt("id").orElseThrow();
                tooltipAdder.accept((Component)Component.translatable((String)"item.integrateddynamics.general.id", (Object[])new Object[]{id}));
            }
            if (tag.contains("maxOffset")) {
                int maxOffset = (Integer)tag.getInt("maxOffset").orElseThrow();
                tooltipAdder.accept((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.maxoffset", (Object[])new Object[]{maxOffset}));
            }
        }
        super.loadTooltip(itemStack, tooltipAdder);
    }

    protected Map<Class<? extends INetworkEvent>, IEventAction> constructNetworkEventActions() {
        return new IdentityHashMap<Class<? extends INetworkEvent>, IEventAction>();
    }

    @Override
    public final boolean hasEventSubscriptions() {
        return !this.networkEventActions.isEmpty();
    }

    @Override
    public final Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return this.networkEventActions.keySet();
    }

    @Override
    public final void onEvent(INetworkEvent event, IPartNetworkElement<P, S> networkElement) {
        if (networkElement.getTarget().getCenter().getPos().isLoaded()) {
            this.networkEventActions.get(event.getClass()).onAction(event.getNetwork(), networkElement.getTarget(), networkElement.getPartState(), event);
        }
    }

    @Override
    public boolean forceLightTransparency(S state) {
        return false;
    }

    @Override
    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        packetBuffer.writeUtf(this.getUniqueName().toString());
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public Block getBlock() {
        return this.block;
    }

    @Override
    public PartRenderPosition getPartRenderPosition() {
        return this.partRenderPosition;
    }

    public static interface IEventAction<P extends IPartType<P, S>, S extends IPartState<P>, E extends INetworkEvent> {
        public void onAction(INetwork var1, PartTarget var2, S var3, E var4);
    }
}

