/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadWorld {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_clear")
    public void testAspectsReadWorldWeatherClearTrue(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_CLEAR, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_rain")
    public void testAspectsReadWorldWeatherClearFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_CLEAR, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_rain")
    public void testAspectsReadWorldWeatherRainingTrue(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_RAINING, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_clear")
    public void testAspectsReadWorldWeatherRainingFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_RAINING, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_thunder")
    public void testAspectsReadWorldWeatherThunderTrue(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_THUNDER, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_clear")
    public void testAspectsReadWorldWeatherThunderFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_WEATHER_THUNDER, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_day")
    public void testAspectsReadWorldIsDayTrue(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_ISDAY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_night")
    public void testAspectsReadWorldIsDayFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_ISDAY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_night")
    public void testAspectsReadWorldIsNightTrue(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_ISNIGHT, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_day")
    public void testAspectsReadWorldIsNightFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.BOOLEAN_ISNIGHT, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:weather_clear2")
    public void testAspectsReadWorldRainCountdown(GameTestHelper helper) {
        helper.getLevel().setWeatherParameters(0, 123, true, false);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.INTEGER_RAINCOUNTDOWN, ValueTypeInteger.ValueInteger.of(123));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldTicktime(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.INTEGER_TICKTIME, ValueTypeInteger.ValueInteger.of((int)((double)Helpers.mean(ServerLifecycleHooks.getCurrentServer().getTickTime(helper.getLevel().dimension())) * 1.0E-6)));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_day_far")
    public void testAspectsReadWorldDaytime(GameTestHelper helper) {
        helper.getLevel().setDayTime((long)(1000 + 10 * IModHelpers.get().getMinecraftHelpers().getDayLength()));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.INTEGER_DAYTIME, ValueTypeInteger.ValueInteger.of(1000));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldLightlevel(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.INTEGER_LIGHTLEVEL, ValueTypeInteger.ValueInteger.of(helper.getLevel().getMaxLocalRawBrightness(helper.absolutePos(POS.west()))));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldTps(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.DOUBLE_TPS, ValueTypeDouble.ValueDouble.of(20.0));
    }

    @GameTest(template="integrateddynamics:empty10", environment="integrateddynamics:time_day_far")
    public void testAspectsReadWorldTime(GameTestHelper helper) {
        helper.getLevel().setDayTime((long)(1000 + 10 * IModHelpers.get().getMinecraftHelpers().getDayLength()));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.LONG_TIME, ValueTypeLong.ValueLong.of(1000 + 10 * IModHelpers.get().getMinecraftHelpers().getDayLength()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldTotalTime(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.LONG_TOTALTIME, ValueTypeLong.ValueLong.of(helper.getLevel().getGameTime()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldName(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.STRING_NAME, ValueTypeString.ValueString.of(((ServerLevelData)helper.getLevel().getLevelData()).getLevelName()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadWorldPlayers(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspectPredicate(POS, helper, PartTypes.WORLD_READER, Aspects.Read.World.LIST_PLAYERS, players -> players.getRawValue() != null);
    }
}

