/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;

public class ContainerPartWriter<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
extends ContainerMultipartAspects<P, S, IAspectWrite<?, ?>> {
    public static final int ASPECT_BOX_HEIGHT = 18;
    private static final int PAGE_SIZE = 6;
    private static final int SLOT_X = 131;
    private static final int SLOT_Y = 18;
    private final int valueId;
    private final int colorId;
    private final int enabledId;
    private final int activeAspectId;
    private final Map<IAspectWrite<?, ?>, Integer> aspectErrorIds;

    public ContainerPartWriter(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (RegistryFriendlyByteBuf)packetBuffer);
    }

    public ContainerPartWriter(int id, Inventory playerInventory, RegistryFriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleInventory(packetBuffer.readInt(), 1), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartTypeWriter)PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerPartWriter(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType) {
        super((MenuType)RegistryEntries.CONTAINER_PART_WRITER.get(), id, playerInventory, inventory, target, partContainer, partType, partType.getWriteAspects());
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.addSlot((Slot)new SlotVariable(this.inputSlots, i, 131, 18 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.addPlayerInventory(this.player.getInventory(), 9, 140);
        this.valueId = this.getNextValueId();
        this.colorId = this.getNextValueId();
        this.enabledId = this.getNextValueId();
        this.activeAspectId = this.getNextValueId();
        this.aspectErrorIds = Maps.newIdentityHashMap();
        for (IAspectWrite<?, ?> aspect : partType.getWriteAspects()) {
            this.aspectErrorIds.put(aspect, this.getNextValueId());
        }
    }

    @Override
    public int getAspectBoxHeight() {
        return 18;
    }

    @Override
    public int getPageSize() {
        return 6;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.getSlot(slotIndex);
        ContainerPartWriter.setSlotPosX((Slot)slot, (int)131);
        ContainerPartWriter.setSlotPosY((Slot)slot, (int)(18 + 18 * row));
    }

    @Override
    protected Container constructInputSlotsInventory() {
        if (!this.player.level().isClientSide()) {
            SimpleInventory inventory = ((IPartStateWriter)this.getPartState()).getInventory();
            inventory.addDirtyMarkListener((IDirtyMarkListener)this);
            return inventory;
        }
        return super.constructInputSlotsInventory();
    }

    public void onDirty() {
        if (!this.player.level().isClientSide()) {
            ((IPartTypeWriter)this.getPartType()).updateActivation(this.getTarget(), (IPartStateWriter)this.getPartState(), this.player, false);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        try {
            if (!this.player.level().isClientSide()) {
                Pair<MutableComponent, Integer> readValue;
                IPartStateWriter partState = (IPartStateWriter)this.getPartState();
                if (!partState.isEnabled()) {
                    readValue = Pair.of((Object)Component.literal((String)"NO POWER"), (Object)0);
                } else if (partState.hasVariable()) {
                    IPartContainer partContainer = this.getPartContainer();
                    Optional<INetwork> optionalNetwork = NetworkHelpers.getNetwork((ILevelExtension)partContainer.getPosition().getLevel(true), partContainer.getPosition().getBlockPos(), this.getTarget().getCenter().getSide());
                    IPartNetwork partNetwork = optionalNetwork.map(NetworkHelpers::getPartNetworkChecked).orElse(null);
                    if (partNetwork != null) {
                        IVariable variable = partState.getVariable(optionalNetwork.orElse(null), partNetwork, ValueDeseralizationContext.of(this.player.level()));
                        readValue = ValueHelpers.getSafeReadableValue(variable);
                    } else {
                        readValue = Pair.of((Object)Component.literal((String)"NETWORK CORRUPTED!"), (Object)IModHelpers.get().getBaseHelpers().RGBAToInt(255, 100, 0, 255));
                    }
                } else {
                    readValue = Pair.of((Object)Component.literal((String)""), (Object)0);
                }
                this.setWriteValue((MutableComponent)readValue.getLeft(), (Integer)readValue.getRight());
                for (IAspectWrite<?, ?> aspectWrite : ((IPartTypeWriter)this.getPartType()).getWriteAspects()) {
                    ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.aspectErrorIds.get(aspectWrite), ((IPartStateWriter)this.getPartState()).getErrors(aspectWrite));
                }
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.enabledId, (boolean)partState.isEnabled());
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.activeAspectId, (String)(partState.getActiveAspect() != null ? partState.getActiveAspect().getUniqueName().toString() : ""));
            }
        }
        catch (PartStateException e) {
            this.player.closeContainer();
        }
    }

    public void setWriteValue(MutableComponent writeValue, int writeColor) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.valueId, (Component)writeValue);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.colorId, (int)writeColor);
    }

    public Component getWriteValue() {
        Component value = ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.valueId);
        if (value == null) {
            value = Component.literal((String)"");
        }
        return value;
    }

    public int getWriteValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.colorId);
    }

    public List<Component> getAspectErrors(IAspectWrite aspectWrite) {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.aspectErrorIds.get(aspectWrite));
    }

    public boolean isPartStateEnabled() {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.enabledId);
    }

    @Nullable
    public IAspect getPartStateActiveAspect() {
        String aspectName = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.activeAspectId);
        if (aspectName == null) {
            return null;
        }
        return AspectRegistry.getInstance().getAspect(ResourceLocation.parse((String)aspectName));
    }
}

