/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public class ActionLabelPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<ActionLabelPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"action_label"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ActionLabelPacket> CODEC = ActionLabelPacket.getCodec(ActionLabelPacket::new);
    @CodecField
    private int variableId;
    @CodecField
    private String label;

    public ActionLabelPacket() {
        super(TYPE);
    }

    public ActionLabelPacket(int variableId, String label) {
        super(TYPE);
        this.variableId = variableId;
        this.label = label;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (this.label == null) {
            LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().removeUnsafe(this.variableId);
        } else {
            LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().putUnsafe(this.variableId, this.label);
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (this.label == null) {
            LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().remove(this.variableId);
        } else {
            LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().put(this.variableId, this.label);
        }
    }
}

