/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.block.BlockDelayConfig;
import org.cyclops.integrateddynamics.core.client.gui.ContainerScreenActiveVariableBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerDelay;

public class ContainerScreenDelay
extends ContainerScreenActiveVariableBase<ContainerDelay> {
    private static final int ERROR_X = 110;
    private static final int ERROR_Y = 26;
    private WidgetNumberField numberFieldUpdateInterval = null;
    private WidgetNumberField numberFieldCapacity = null;

    public ContainerScreenDelay(ContainerDelay container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/delay.png");
    }

    protected int getBaseYSize() {
        return 227;
    }

    @Override
    protected int getErrorX() {
        return 110;
    }

    @Override
    protected int getErrorY() {
        return 26;
    }

    public void init() {
        super.init();
        this.numberFieldUpdateInterval = new WidgetNumberField(this.font, this.leftPos + 98, this.topPos + 102, 73, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.update_interval"), true);
        this.numberFieldUpdateInterval.setPositiveOnly(true);
        this.numberFieldUpdateInterval.setMaxLength(64);
        this.numberFieldUpdateInterval.setMaxLength(15);
        this.numberFieldUpdateInterval.setVisible(true);
        this.numberFieldUpdateInterval.setTextColor(0xFFFFFF);
        this.numberFieldUpdateInterval.setCanLoseFocus(true);
        this.addWidget((GuiEventListener)this.numberFieldUpdateInterval);
        this.numberFieldCapacity = new WidgetNumberField(this.font, this.leftPos + 98, this.topPos + 126, 73, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.delay.capacity"), true);
        this.numberFieldCapacity.setMinValue(1);
        this.numberFieldCapacity.setMaxValue(BlockDelayConfig.maxHistoryCapacity);
        this.numberFieldCapacity.setMaxLength(64);
        this.numberFieldCapacity.setMaxLength(15);
        this.numberFieldCapacity.setVisible(true);
        this.numberFieldCapacity.setTextColor(0xFFFFFF);
        this.numberFieldCapacity.setCanLoseFocus(true);
        this.addWidget((GuiEventListener)this.numberFieldCapacity);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.numberFieldUpdateInterval.charTyped(typedChar, keyCode) && !this.numberFieldCapacity.charTyped(typedChar, keyCode)) {
            return super.charTyped(typedChar, keyCode);
        }
        this.onValueChanged();
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (!this.numberFieldUpdateInterval.keyPressed(typedChar, keyCode, modifiers) && !this.numberFieldCapacity.keyPressed(typedChar, keyCode, modifiers)) {
            return super.keyPressed(typedChar, keyCode, modifiers);
        }
        this.onValueChanged();
        return true;
    }

    protected void onValueChanged() {
        int updateInterval = 1;
        int capacity = 5;
        try {
            updateInterval = this.numberFieldUpdateInterval.getInt();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            capacity = this.numberFieldCapacity.getInt();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerDelay)this.getMenu()).getLastUpdateValueId(), (int)updateInterval);
        ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerDelay)this.getMenu()).getLastCapacityValueId(), (int)capacity);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clicked = false;
        if (this.numberFieldUpdateInterval.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.onValueChanged();
            clicked = true;
        }
        if (this.numberFieldCapacity.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.onValueChanged();
            clicked = true;
        }
        return clicked || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.numberFieldUpdateInterval.render(guiGraphics, mouseX - this.leftPos, mouseY - this.topPos, partialTicks);
        this.numberFieldCapacity.render(guiGraphics, mouseX - this.leftPos, mouseY - this.topPos, partialTicks);
        this.font.drawInBatch((Component)Component.translatable((String)"gui.integrateddynamics.partsettings.update_interval"), (float)(this.leftPos + 8), (float)(this.topPos + 104), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.font.drawInBatch((Component)Component.translatable((String)"gui.integrateddynamics.delay.capacity"), (float)(this.leftPos + 8), (float)(this.topPos + 128), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.font.drawInBatch(this.title, (float)this.titleLabelX, (float)this.titleLabelY, 0x404040, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.displayErrors.drawForeground(guiGraphics.pose(), ((ContainerDelay)this.getMenu()).getReadErrors(), this.getErrorX(), this.getErrorY(), mouseX, mouseY, this, this.leftPos, this.topPos);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (valueId == ((ContainerDelay)this.getMenu()).getLastUpdateValueId()) {
            this.numberFieldUpdateInterval.setValue(Integer.toString(((ContainerDelay)this.getMenu()).getLastUpdateValue()));
        }
        if (valueId == ((ContainerDelay)this.getMenu()).getLastCapacityValueId()) {
            this.numberFieldCapacity.setValue(Integer.toString(((ContainerDelay)this.getMenu()).getLastCapacityValue()));
        }
    }
}

