/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.GeneralConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.modcompat.common.JeiReiHelpers;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class LogicProgrammerTransferHandler<T extends ContainerLogicProgrammerBase>
implements IRecipeTransferHandler<T, Object> {
    private final Class<T> clazz;

    public LogicProgrammerTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<Object> getRecipeType() {
        return Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = ((ContainerLogicProgrammerBase)((Object)container)).getActiveElement();
        if (element instanceof ValueTypeRecipeLPElement) {
            return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, recipeLayout, doTransfer);
        }
        return null;
    }

    @Nullable
    protected ResourceLocation getHeuristicItemsTag(IRecipeSlotView jeiIngredient) {
        if (!GeneralConfig.jeiHeuristicTags) {
            return null;
        }
        List<Item> items = jeiIngredient.getAllIngredients().map(typedIngredient -> (ItemStack)typedIngredient.getIngredient()).map(ItemStack::getItem).collect(Collectors.toList());
        if (items.size() > 1) {
            return JeiReiHelpers.itemsToTag(items);
        }
        return null;
    }

    protected IRecipeTransferError handleRecipeElement(ValueTypeRecipeLPElement element, T container, IRecipeSlotsView recipeLayout, boolean doTransfer) {
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
            if (slotView.isEmpty()) {
                itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY));
                continue;
            }
            ITypedIngredient typedIngredient = (ITypedIngredient)slotView.getAllIngredients().findFirst().get();
            if (typedIngredient.getType() == VanillaTypes.ITEM_STACK) {
                if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                    ResourceLocation heuristicTag = this.getHeuristicItemsTag(slotView);
                    if (heuristicTag != null) {
                        itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY, false, heuristicTag.toString(), ((ItemStack)typedIngredient.getIngredient()).getCount()));
                        continue;
                    }
                    itemInputs.add(new ItemMatchProperties(((ItemStack)typedIngredient.getIngredient()).copy()));
                    continue;
                }
                if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
                itemOutputs.add(((ItemStack)typedIngredient.getIngredient()).copy());
                continue;
            }
            if (typedIngredient.getType() != NeoForgeTypes.FLUID_STACK) continue;
            if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                fluidInputs.add(((FluidStack)typedIngredient.getIngredient()).copy());
                continue;
            }
            if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
            fluidOutputs.add(((FluidStack)typedIngredient.getIngredient()).copy());
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return new IRecipeTransferError(this){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
                    guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, Collections.singletonList(Component.translatable((String)"error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc")), mouseX, mouseY);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)((Object)container), itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(((ContainerLogicProgrammerBase)((Object)container)).containerId, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return null;
    }
}

