/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.core.path.Cluster;

public final class PathFinder {
    protected static Set<ISidedPathElement> getConnectedElements(ISidedPathElement head) {
        HashSet<ISidedPathElement> connectedElements = new HashSet<ISidedPathElement>();
        HashSet<DimPos> visitedPositions = new HashSet<DimPos>();
        ArrayDeque<ISidedPathElement> queue = new ArrayDeque<ISidedPathElement>();
        DimPos headPos = head.getPathElement().getPosition();
        visitedPositions.add(headPos);
        queue.offer(head);
        while (!queue.isEmpty()) {
            ISidedPathElement current = (ISidedPathElement)queue.poll();
            connectedElements.add(current);
            IPathElement currentElement = current.getPathElement();
            for (ISidedPathElement neighbour : currentElement.getReachableElements()) {
                DimPos neighbourPos = neighbour.getPathElement().getPosition();
                if (!visitedPositions.add(neighbourPos)) continue;
                queue.offer(neighbour);
            }
        }
        return connectedElements;
    }

    public static Cluster getConnectedCluster(ISidedPathElement head) {
        return new Cluster(new TreeSet<ISidedPathElement>(PathFinder.getConnectedElements(head)));
    }
}

