/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class SqueezerRecipeAppendix
extends RecipeAppendix<RecipeSqueezer> {
    private static final int SLOT_INPUT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int SLOT_OUTPUT_OFFSET_X = 68;
    private static final AdvancedButtonEnum INPUT_ITEM = AdvancedButtonEnum.create();
    private static final AdvancedButtonEnum RESULT_FLUID = AdvancedButtonEnum.create();
    private final List<AdvancedButtonEnum> resultItems = Lists.newArrayList();

    public SqueezerRecipeAppendix(IInfoBook infoBook, RecipeHolder<? extends RecipeSqueezer> recipe) {
        super(infoBook, recipe);
        for (int i = 0; i < ((RecipeSqueezer)recipe.value()).getOutputItems().size(); ++i) {
            this.resultItems.add(AdvancedButtonEnum.create());
        }
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return (((RecipeSqueezer)this.recipe.value()).getOutputFluid().isPresent() ? 23 : 0) + this.resultItems.size() * 23 - 3;
    }

    protected String getUnlocalizedTitle() {
        return "block.integrateddynamics.squeezer";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT_ITEM, new RecipeAppendix.ItemButton(this.getInfoBook()));
        for (AdvancedButtonEnum resultItem : this.resultItems) {
            this.renderItemHolders.put(resultItem, new RecipeAppendix.ItemButton(this.getInfoBook()));
        }
        this.renderItemHolders.put(RESULT_FLUID, new RecipeAppendix.FluidButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(guiGraphics, x + middle - 3, y + 2);
        int tick = this.getTick(gui);
        ItemStack inputItem = ((RecipeSqueezer)this.recipe.value()).getInputIngredient() == null ? null : this.prepareItemStacks(((RecipeSqueezer)this.recipe.value()).getInputIngredient().getItems(), tick);
        List outputItems = ((RecipeSqueezer)this.recipe.value()).getOutputItems().stream().map(RecipeSqueezer.IngredientChance::getIngredientFirst).collect(Collectors.toList());
        Optional<FluidStack> outputFluid = ((RecipeSqueezer)this.recipe.value()).getOutputFluid();
        this.renderItem(gui, guiGraphics, x + 16, y, inputItem, mx, my, INPUT_ITEM);
        int slotOffset = 0;
        for (int i = 0; i < outputItems.size(); ++i) {
            this.renderItem(gui, guiGraphics, x + 68, y + slotOffset, (ItemStack)outputItems.get(i), mx, my, this.resultItems.get(i), ((RecipeSqueezer.IngredientChance)((RecipeSqueezer)this.recipe.value()).getOutputItems().get(i)).getChance());
            slotOffset += 23;
        }
        if (outputFluid.isPresent()) {
            this.renderFluid(gui, guiGraphics, x + 68, y + slotOffset, outputFluid.get(), mx, my, RESULT_FLUID);
        }
        this.renderItem(gui, guiGraphics, x + middle, y, this.getCrafter(), mx, my, false, null);
    }

    protected ItemStack getCrafter() {
        return new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER.get());
    }
}

