/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.common;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketSetSlot;

public class JeiReiHelpers {
    public static ResourceLocation itemsToTag(List<Item> items) {
        return BuiltInRegistries.ITEM.getTagNames().map(tag -> BuiltInRegistries.ITEM.getTag(tag).flatMap(t -> {
            if (t.stream().map(Holder::value).collect(Collectors.toList()).equals(items)) {
                return Optional.of(tag.location());
            }
            return Optional.empty();
        })).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    public static void setStackInSlot(ContainerScreenLogicProgrammerBase<?> screen, int slot, ItemStack itemStack) {
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)screen.getMenu();
        int slotPositionsCount = container.slots.size() - 36 - 4;
        int slotId = container.slots.size() - 36 - slotPositionsCount + slot;
        container.setItem(slotId, 0, itemStack.copy());
        IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketSetSlot(container.containerId, slotId, itemStack));
    }

    public static MutableComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / 20.0);
        return Component.translatable((String)"gui.integrateddynamics.jei.category.time.seconds", (Object[])new Object[]{seconds});
    }

    public static MutableComponent getEnergyTextComponent(int durationTicks, int energyPerTick) {
        return Component.literal((String)String.format("%,d", durationTicks * energyPerTick)).append((Component)Component.translatable((String)"general.integrateddynamics.energy_unit"));
    }
}

