/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectable;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.network.EnergyBatteryNetworkElement;

public class BlockEntityEnergyBattery
extends BlockEntityCableConnectable
implements IEnergyStorageCapacity {
    @NBTPersist
    private int energy;
    @NBTPersist(useDefaultValue=false)
    private int capacity = BlockEnergyBatteryConfig.capacity;

    public BlockEntityEnergyBattery(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENERGY_BATTERY.get(), blockPos, blockState);
    }

    @Override
    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(this){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new EnergyBatteryNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        };
    }

    public boolean isCreative() {
        Block block = this.getBlockState().getBlock();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public int getEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    protected void setEnergy(int energy) {
        int lastEnergy;
        if (!this.isCreative() && (lastEnergy = this.energy) != energy) {
            this.energy = energy;
            this.setChanged();
            this.sendUpdate();
        }
    }

    public int getUpdateBackoffTicks() {
        return 20;
    }

    public static int getEnergyPerTick(int capacity) {
        return Math.max(capacity / BlockEnergyBatteryConfig.energyRateCapacityFraction, BlockEnergyBatteryConfig.minEnergyRate);
    }

    protected int getEnergyPerTick() {
        return BlockEntityEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (!this.isCreative()) {
            int stored = this.getEnergyStored();
            int energyReceived = Math.min(this.getMaxEnergyStored() - stored, energy);
            if (!simulate) {
                this.setEnergy(stored + energyReceived);
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        energy = Math.max(0, Math.min(energy, this.getEnergyPerTick()));
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    protected int addEnergy(int energy) {
        int filled = this.addEnergyFe(energy, false);
        this.extractEnergy(filled, false);
        return filled;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.getLevel(), this.getBlockPos(), energy, simulate);
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public static class Ticker
    extends BlockEntityCableConnectable.Ticker<BlockEntityEnergyBattery> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEnergyBattery blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.getEnergyStored() > 0 && level.hasNeighborSignal(pos)) {
                blockEntity.addEnergy(Math.min(blockEntity.getEnergyPerTick(), blockEntity.getEnergyStored()));
            }
        }

        protected void onSendUpdate(Level level, BlockPos pos) {
            BlockState blockState = level.getBlockState(pos);
            level.sendBlockUpdated(pos, blockState, blockState, IModHelpers.get().getMinecraftHelpers().getBlockNotify() | IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient() | IModHelpers.get().getMinecraftHelpers().getBlockNotifyNoRerender());
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCableConnectable.CapabilityRegistrar<BlockEntityEnergyBattery> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityEnergyBattery>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.NetworkElementProvider.BLOCK, (blockEntity, context) -> blockEntity.getNetworkElementProvider());
            this.add(Capabilities.EnergyStorage.BLOCK, (blockEntity, context) -> blockEntity);
        }
    }
}

