/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartOffset;

public class ContainerScreenPartOffset<T extends ContainerPartOffset>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldX = null;
    private WidgetNumberField numberFieldY = null;
    private WidgetNumberField numberFieldZ = null;

    public ContainerScreenPartOffset(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartOffset)this.getMenu()).getLastXValueId(), (int)this.numberFieldX.getInt());
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartOffset)this.getMenu()).getLastYValueId(), (int)this.numberFieldY.getInt());
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartOffset)this.getMenu()).getLastZValueId(), (int)this.numberFieldZ.getInt());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/part_offsets.png");
    }

    public void init() {
        super.init();
        this.numberFieldX = new WidgetNumberField(this.font, this.leftPos + 107 - 54 - 7 - 18, this.topPos + 33, 46, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldX.setMaxLength(4);
        this.numberFieldX.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldX.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldX.setVisible(true);
        this.numberFieldX.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.numberFieldX.setCanLoseFocus(true);
        this.numberFieldY = new WidgetNumberField(this.font, this.leftPos + 107 - 54 + 36 - 7, this.topPos + 33, 46, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldY.setMaxLength(4);
        this.numberFieldY.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldY.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldY.setVisible(true);
        this.numberFieldY.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.numberFieldY.setCanLoseFocus(true);
        this.numberFieldZ = new WidgetNumberField(this.font, this.leftPos + 107 - 54 + 72 - 7 + 18, this.topPos + 33, 46, 14, true, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldZ.setMaxLength(4);
        this.numberFieldZ.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldZ.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldZ.setVisible(true);
        this.numberFieldZ.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.numberFieldZ.setCanLoseFocus(true);
        MutableComponent save = Component.translatable((String)"gui.integrateddynamics.button.save");
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 178, this.topPos + 6, this.font.width(save.getVisualOrderText()) + 6, 16, (Component)save, (Component)save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!(this.numberFieldX.charTyped(typedChar, keyCode) || this.numberFieldY.charTyped(typedChar, keyCode) || this.numberFieldZ.charTyped(typedChar, keyCode))) {
            this.onSave();
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.numberFieldX.keyPressed(typedChar, keyCode, modifiers) || this.numberFieldY.keyPressed(typedChar, keyCode, modifiers) || this.numberFieldZ.keyPressed(typedChar, keyCode, modifiers)) {
                this.onSave();
                return true;
            }
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.numberFieldX.mouseClicked(mouseX, mouseY, mouseButton) || this.numberFieldY.mouseClicked(mouseX, mouseY, mouseButton) || this.numberFieldZ.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.onSave();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.integrateddynamics.part_offsets"), this.titleLabelX, this.titleLabelY, ARGB.opaque((int)0x404040), false);
        guiGraphics.drawString(this.font, "X", this.leftPos + 45 + 5, this.topPos + 19, ARGB.opaque((int)0), false);
        guiGraphics.drawString(this.font, "Y", this.leftPos + 99 + 5, this.topPos + 19, ARGB.opaque((int)0), false);
        guiGraphics.drawString(this.font, "Z", this.leftPos + 153 + 5, this.topPos + 19, ARGB.opaque((int)0), false);
        this.numberFieldX.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.numberFieldY.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.numberFieldZ.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 3; ++i) {
            int x = this.leftPos + 64 + i * 54;
            if (!((ContainerPartOffset)this.getMenu()).isOffsetVariableFilled(i)) continue;
            Image image = ((ContainerPartOffset)this.container).getOffsetVariableError(i) == null ? Images.OK : Images.ERROR;
            image.draw(guiGraphics, x, this.topPos + 52);
        }
        if (((ContainerPartOffset)this.getMenu()).getMaxOffset() == 0) {
            Images.ERROR.draw(guiGraphics, this.leftPos + 74, this.topPos + 3);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovering(0, 0, 90, 18, mouseX, mouseY)) {
            ArrayList lines = Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.partoffset.offsets"), Component.translatable((String)"gui.integrateddynamics.partoffset.offsets.max", (Object[])new Object[]{((ContainerPartOffset)this.getMenu()).getMaxOffset()}).withStyle(ChatFormatting.GRAY)});
            if (((ContainerPartOffset)this.getMenu()).getMaxOffset() == 0) {
                lines.add(Component.translatable((String)"gui.integrateddynamics.partoffset.offsets.max.howtoincrease", (Object[])new Object[]{((ContainerPartOffset)this.getMenu()).getMaxOffset()}).withStyle(ChatFormatting.RED));
            }
            this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
        }
        int i = 0;
        while (i < 3) {
            int x = 64 + i * 54;
            int slot = i++;
            IModHelpers.get().getGuiHelpers().renderTooltipOptional((AbstractContainerScreen)this, guiGraphics, x, 52, 14, 13, mouseX, mouseY, () -> {
                Component unlocalizedMessage = ((ContainerPartOffset)this.container).getOffsetVariableError(slot);
                if (unlocalizedMessage != null) {
                    return Optional.of(Collections.singletonList(unlocalizedMessage));
                }
                return Optional.empty();
            });
        }
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 155;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (valueId == ((ContainerPartOffset)this.getMenu()).getLastXValueId()) {
            this.numberFieldX.setValue(Integer.toString(((ContainerPartOffset)this.getMenu()).getLastXValue()));
        }
        if (valueId == ((ContainerPartOffset)this.getMenu()).getLastYValueId()) {
            this.numberFieldY.setValue(Integer.toString(((ContainerPartOffset)this.getMenu()).getLastYValue()));
        }
        if (valueId == ((ContainerPartOffset)this.getMenu()).getLastZValueId()) {
            this.numberFieldZ.setValue(Integer.toString(((ContainerPartOffset)this.getMenu()).getLastZValue()));
        }
        this.numberFieldX.setEditable(!((ContainerPartOffset)this.getMenu()).isOffsetVariableFilled(0));
        this.numberFieldY.setEditable(!((ContainerPartOffset)this.getMenu()).isOffsetVariableFilled(1));
        this.numberFieldZ.setEditable(!((ContainerPartOffset)this.getMenu()).isOffsetVariableFilled(2));
        if (valueId == ((ContainerPartOffset)this.getMenu()).getMaxOffsetId()) {
            int max = ((ContainerPartOffset)this.getMenu()).getMaxOffset();
            this.numberFieldX.setMaxValue(max);
            this.numberFieldX.setMinValue(-max);
            this.numberFieldY.setMaxValue(max);
            this.numberFieldY.setMinValue(-max);
            this.numberFieldZ.setMaxValue(max);
            this.numberFieldZ.setMinValue(-max);
        }
    }
}

