/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeDropdownList;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeOperatorLPElementClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeOperatorValueChangedPacket;

public class ValueTypeOperatorLPElement
extends ValueTypeLPElementBase<ValueTypeOperatorLPElementClient>
implements IDropdownEntryListener {
    private IOperator selectedOperator = null;
    private GuiElementValueTypeDropdownList<IOperator, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> innerGuiElement;

    public ValueTypeOperatorLPElement() {
        super(ValueTypes.OPERATOR);
        LinkedHashSet operatorEntries = Sets.newLinkedHashSet();
        for (IOperator operator : Operators.REGISTRY.getOperators()) {
            operatorEntries.add(new OperatorDropdownEntry(operator));
        }
        this.innerGuiElement = new GuiElementValueTypeDropdownList(this.getValueType(), this.getRenderPattern());
        ((GuiElementValueTypeDropdownList)this.getInnerGuiElement()).setDropdownPossibilities(operatorEntries);
        ((GuiElementValueTypeDropdownList)this.getInnerGuiElement()).setDropdownEntryListener(this);
    }

    @Override
    public ValueTypeOperatorLPElementClient constructClient() {
        return new ValueTypeOperatorLPElementClient(this);
    }

    public GuiElementValueTypeDropdownList<IOperator, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> getInnerGuiElement() {
        return this.innerGuiElement;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public Component validate() {
        if (this.selectedOperator == null) {
            return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{((GuiElementValueTypeDropdownList)this.getInnerGuiElement()).getInputString()});
        }
        return null;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS;
    }

    @Override
    public boolean canWriteElementPre() {
        return this.selectedOperator != null;
    }

    @Override
    public IValue getValue() {
        return ValueTypeOperator.ValueOperator.of(this.selectedOperator);
    }

    @Override
    public void setValue(IValue value) {
        this.selectedOperator = ((ValueTypeOperator.ValueOperator)value).getRawValue();
    }

    @Override
    public void activate() {
    }

    public void onSetDropdownPossiblity(IDropdownEntry dropdownEntry) {
        OperatorDropdownEntry operatorDropdownEntry = (OperatorDropdownEntry)dropdownEntry;
        IOperator iOperator = this.selectedOperator = operatorDropdownEntry == null ? null : operatorDropdownEntry.getValue();
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread() && this.selectedOperator != null) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeOperatorValueChangedPacket(ValueDeseralizationContext.ofClient(), ValueTypeOperator.ValueOperator.of(this.selectedOperator)));
        }
    }

    public IOperator getSelectedOperator() {
        return this.selectedOperator;
    }

    public void setSelectedOperator(IOperator selectedOperator) {
        this.selectedOperator = selectedOperator;
    }

    public static class OperatorDropdownEntry
    implements IDropdownEntry<IOperator> {
        private final IOperator operator;

        public OperatorDropdownEntry(IOperator operator) {
            this.operator = operator;
        }

        @Override
        public String getMatchString() {
            return this.operator.getLocalizedNameFull().getString();
        }

        @Override
        public MutableComponent getDisplayString() {
            return Component.literal((String)this.getMatchString());
        }

        @Override
        public List<MutableComponent> getTooltip() {
            return ValueTypeOperator.getSignatureLines(this.operator, true);
        }

        @Override
        public IOperator getValue() {
            return this.operator;
        }
    }
}

