/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.client.render.level.PartOffsetsOverlayRenderer;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDataClient;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.http.DiagnosticsWebServer;
import org.cyclops.integrateddynamics.proxy.CommonProxy;

public class ClientProxy
extends ClientProxyComponent {
    public static DiagnosticsWebServer DIAGNOSTICS_SERVER;
    private static final String KEYBINDING_CATEGORY_NAME = "key.categories.integrateddynamics";
    public static final KeyMapping FOCUS_LP_SEARCH;
    public static final KeyMapping FOCUS_LP_RENAME;

    public ClientProxy() {
        super((CommonProxyComponent)new CommonProxy());
        IntegratedDynamics._instance.getModEventBus().addListener(this::onPostTextureStitch);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
    }

    public ModBaseNeoForge getMod() {
        return IntegratedDynamics._instance;
    }

    public void registerEventHooks() {
        super.registerEventHooks();
        NeoForge.EVENT_BUS.register((Object)NetworkDiagnosticsPartOverlayRenderer.getInstance());
        NeoForge.EVENT_BUS.register((Object)PartOffsetsOverlayRenderer.getInstance());
    }

    public void registerKeyBindings(IKeyRegistry keyRegistry, RegisterKeyMappingsEvent event) {
        super.registerKeyBindings(keyRegistry, event);
        event.register(FOCUS_LP_SEARCH);
        event.register(FOCUS_LP_RENAME);
    }

    public void onPostTextureStitch(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            event.getAtlas().getSprite(SlotVariable.VARIABLE_EMPTY);
        }
    }

    public void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (DIAGNOSTICS_SERVER != null) {
            IntegratedDynamics.clog("Stopping diagnostics server...");
            NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
            NetworkDataClient.clearNetworkData();
            PartOffsetsOverlayRenderer.getInstance().clear();
            DIAGNOSTICS_SERVER.deinitialize();
            DIAGNOSTICS_SERVER = null;
            IntegratedDynamics.clog("Stopped diagnostics server");
        }
    }

    static {
        FOCUS_LP_SEARCH = new KeyMapping("key.integrateddynamics.logic_programmer_focus_search", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.ALT, InputConstants.Type.KEYSYM, 70, KEYBINDING_CATEGORY_NAME);
        FOCUS_LP_RENAME = new KeyMapping("key.integrateddynamics.logic_programmer_open_rename", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.ALT, InputConstants.Type.KEYSYM, 82, KEYBINDING_CATEGORY_NAME);
    }
}

