/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.variable;

import java.util.Comparator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeClient;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;

public interface IValueType<V extends IValue> {
    public IValueTypeClient<V> getClient();

    public boolean isCategory();

    public boolean isObject();

    public V getDefault();

    public String getTypeName();

    public ResourceLocation getUniqueName();

    public String getTranslationKey();

    public void loadTooltip(Consumer<Component> var1, boolean var2, @Nullable V var3);

    public MutableComponent toCompactString(V var1);

    public int getDisplayColor();

    public ChatFormatting getDisplayColorFormat();

    public boolean correspondsTo(IValueType<?> var1);

    public void serialize(ValueOutput var1, V var2);

    @Nullable
    public Component canDeserialize(ValueInput var1);

    public V deserialize(ValueInput var1);

    public V materialize(V var1) throws EvaluationException;

    public String toString(V var1);

    public V parseString(String var1) throws EvaluationException;

    public IValueTypeLogicProgrammerElement createLogicProgrammerElement();

    public V cast(IValue var1) throws EvaluationException;

    public static class ValueTypeComparator
    implements Comparator<IValueType<?>> {
        private static ValueTypeComparator INSTANCE = null;

        private ValueTypeComparator() {
        }

        public static ValueTypeComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ValueTypeComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IValueType<?> o1, IValueType<?> o2) {
            return o1.getUniqueName().compareTo(o2.getUniqueName());
        }
    }
}

