/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.inventory.container.ContainerLabeller;
import org.cyclops.integrateddynamics.network.packet.ItemStackRenamePacket;

public class ContainerScreenLabeller
extends ContainerScreenExtended<ContainerLabeller> {
    private WidgetTextFieldExtended searchField;

    public ContainerScreenLabeller(ContainerLabeller container, Inventory playerInventory, Component title) {
        super((ContainerExtended)container, playerInventory, title);
        SimpleInventory temporaryInputSlots = container.getTemporaryInputSlots();
        temporaryInputSlots.addDirtyMarkListener(() -> {
            ItemStack itemStack = temporaryInputSlots.getItem(0);
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = registry.handle(ValueDeseralizationContext.of(container.getPlayerIInventory().player.level()), itemStack);
            String label = LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().getLabel(variableFacade.getId());
            if (label == null && !itemStack.isEmpty() && itemStack.has(DataComponents.CUSTOM_NAME)) {
                label = itemStack.getHoverName().getString();
            }
            if (label != null) {
                this.setText(label);
            }
        });
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/labeller.png");
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 133, this.topPos + 8, (Component)Component.translatable((String)"item.integrateddynamics.labeller.button.write"), (Component)Component.translatable((String)"item.integrateddynamics.labeller.button.write"), button -> {
            ItemStack itemStack = ((ContainerLabeller)this.getMenu()).getItemStack();
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = registry.handle(ValueDeseralizationContext.of(((ContainerLabeller)this.container).getPlayerIInventory().player.level()), itemStack);
            if (variableFacade.isValid()) {
                int variableId = variableFacade.getId();
                String label = StringUtils.isBlank((CharSequence)this.searchField.getValue()) ? "" : this.searchField.getValue();
                LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().put(variableId, label);
            } else if (!itemStack.isEmpty()) {
                String name = this.searchField.getValue();
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new ItemStackRenamePacket(name));
                ((ContainerLabeller)this.getMenu()).setItemStackName(name);
            }
        }));
        int searchWidth = 87;
        int searchX = 36;
        int searchY = 11;
        Objects.requireNonNull(this.font);
        this.searchField = new WidgetTextFieldExtended(this.font, this.leftPos + searchX, this.topPos + searchY, searchWidth, 9, (Component)Component.translatable((String)"gui.cyclopscore.search"));
        this.searchField.setMaxLength(64);
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setFocused(true);
        this.searchField.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.searchField.setCanLoseFocus(false);
        this.searchField.setValue("");
        this.searchField.setX(this.leftPos + (searchX + searchWidth) - this.searchField.getWidth());
    }

    protected int getBaseYSize() {
        return 113;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.searchField.charTyped(typedChar, keyCode)) {
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            this.searchField.keyPressed(typedChar, keyCode, modifiers);
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.searchField.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.searchField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void setText(String text) {
        this.searchField.setValue(text);
    }
}

