/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.helper.IBlockHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeUniquelyNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block", ValueBlock.class);
    }

    public static MutableComponent getBlockkDisplayNameSafe(BlockState blockState) {
        return Component.translatable((String)blockState.getBlock().getDescriptionId());
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(Blocks.AIR.defaultBlockState());
    }

    @Override
    public MutableComponent toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            ItemStack itemStack = IModHelpers.get().getBlockHelpers().getItemStackFromBlockState(blockState);
            if (!itemStack.isEmpty()) {
                return ValueObjectTypeItemStack.getItemStackDisplayNameSafe(itemStack);
            }
            return ValueObjectTypeBlock.getBlockkDisplayNameSafe(blockState);
        }
        return Component.literal((String)"");
    }

    @Override
    public void serialize(ValueOutput valueOutput, ValueBlock value) {
        value.getRawValue().ifPresent(v -> valueOutput.store("v", BlockState.CODEC, v));
    }

    @Override
    public ValueBlock deserialize(ValueInput valueInput) {
        return ValueBlock.of(valueInput.read("v", BlockState.CODEC).orElseGet(() -> ((Block)Blocks.AIR).defaultBlockState()));
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueBlock>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueBlock>(this){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                if (!itemStack.isEmpty() && !(itemStack.getItem() instanceof BlockItem)) {
                    return Component.translatable((String)"valuetype.integrateddynamics.error.block.no_block");
                }
                return null;
            }

            @Override
            public ValueBlock getValue(ItemStack itemStack) {
                return ValueBlock.of(itemStack.isEmpty() ? Blocks.AIR.defaultBlockState() : IModHelpers.get().getBlockHelpers().getBlockStateFromItemStack(itemStack));
            }

            @Override
            public ItemStack getValueAsItemStack(ValueBlock value) {
                return value.getRawValue().map(arg_0 -> ((IBlockHelpers)IModHelpers.get().getBlockHelpers()).getItemStackFromBlockState(arg_0)).orElse(ItemStack.EMPTY);
            }
        });
    }

    @Override
    public String getUniqueName(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            BlockState blockState = (BlockState)value.getRawValue().get();
            return BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString();
        }
        return "";
    }

    public static class ValueBlock
    extends ValueOptionalBase<BlockState> {
        private ValueBlock(BlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(BlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(BlockState a, BlockState b) {
            return a.equals((Object)b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

